/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright;

import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.options.ColorScheme;
import com.microsoft.playwright.options.ForcedColors;
import com.microsoft.playwright.options.Geolocation;
import com.microsoft.playwright.options.HarContentPolicy;
import com.microsoft.playwright.options.HarMode;
import com.microsoft.playwright.options.HttpCredentials;
import com.microsoft.playwright.options.Proxy;
import com.microsoft.playwright.options.RecordVideoSize;
import com.microsoft.playwright.options.ReducedMotion;
import com.microsoft.playwright.options.ScreenSize;
import com.microsoft.playwright.options.ServiceWorkerPolicy;
import com.microsoft.playwright.options.ViewportSize;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public interface Browser
extends AutoCloseable {
    public void onDisconnected(Consumer<Browser> var1);

    public void offDisconnected(Consumer<Browser> var1);

    public BrowserType browserType();

    @Override
    public void close();

    public List<BrowserContext> contexts();

    public boolean isConnected();

    default public BrowserContext newContext() {
        return this.newContext(null);
    }

    public BrowserContext newContext(NewContextOptions var1);

    default public Page newPage() {
        return this.newPage(null);
    }

    public Page newPage(NewPageOptions var1);

    default public void startTracing(Page page) {
        this.startTracing(page, null);
    }

    default public void startTracing() {
        this.startTracing(null);
    }

    public void startTracing(Page var1, StartTracingOptions var2);

    public byte[] stopTracing();

    public String version();

    public static class StartTracingOptions {
        public List<String> categories;
        public Path path;
        public Boolean screenshots;

        public StartTracingOptions setCategories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public StartTracingOptions setPath(Path path) {
            this.path = path;
            return this;
        }

        public StartTracingOptions setScreenshots(boolean screenshots) {
            this.screenshots = screenshots;
            return this;
        }
    }

    public static class NewPageOptions {
        public Boolean acceptDownloads;
        public String baseURL;
        public Boolean bypassCSP;
        public ColorScheme colorScheme;
        public Double deviceScaleFactor;
        public Map<String, String> extraHTTPHeaders;
        public ForcedColors forcedColors;
        public Geolocation geolocation;
        public Boolean hasTouch;
        public HttpCredentials httpCredentials;
        public Boolean ignoreHTTPSErrors;
        public Boolean isMobile;
        public Boolean javaScriptEnabled;
        public String locale;
        public Boolean offline;
        public List<String> permissions;
        public Proxy proxy;
        public HarContentPolicy recordHarContent;
        public HarMode recordHarMode;
        public Boolean recordHarOmitContent;
        public Path recordHarPath;
        public Object recordHarUrlFilter;
        public Path recordVideoDir;
        public RecordVideoSize recordVideoSize;
        public ReducedMotion reducedMotion;
        public ScreenSize screenSize;
        public ServiceWorkerPolicy serviceWorkers;
        public String storageState;
        public Path storageStatePath;
        public Boolean strictSelectors;
        public String timezoneId;
        public String userAgent;
        public Optional<ViewportSize> viewportSize;

        public NewPageOptions setAcceptDownloads(boolean acceptDownloads) {
            this.acceptDownloads = acceptDownloads;
            return this;
        }

        public NewPageOptions setBaseURL(String baseURL) {
            this.baseURL = baseURL;
            return this;
        }

        public NewPageOptions setBypassCSP(boolean bypassCSP) {
            this.bypassCSP = bypassCSP;
            return this;
        }

        public NewPageOptions setColorScheme(ColorScheme colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        public NewPageOptions setDeviceScaleFactor(double deviceScaleFactor) {
            this.deviceScaleFactor = deviceScaleFactor;
            return this;
        }

        public NewPageOptions setExtraHTTPHeaders(Map<String, String> extraHTTPHeaders) {
            this.extraHTTPHeaders = extraHTTPHeaders;
            return this;
        }

        public NewPageOptions setForcedColors(ForcedColors forcedColors) {
            this.forcedColors = forcedColors;
            return this;
        }

        public NewPageOptions setGeolocation(double latitude, double longitude) {
            return this.setGeolocation(new Geolocation(latitude, longitude));
        }

        public NewPageOptions setGeolocation(Geolocation geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public NewPageOptions setHasTouch(boolean hasTouch) {
            this.hasTouch = hasTouch;
            return this;
        }

        public NewPageOptions setHttpCredentials(String username, String password) {
            return this.setHttpCredentials(new HttpCredentials(username, password));
        }

        public NewPageOptions setHttpCredentials(HttpCredentials httpCredentials) {
            this.httpCredentials = httpCredentials;
            return this;
        }

        public NewPageOptions setIgnoreHTTPSErrors(boolean ignoreHTTPSErrors) {
            this.ignoreHTTPSErrors = ignoreHTTPSErrors;
            return this;
        }

        public NewPageOptions setIsMobile(boolean isMobile) {
            this.isMobile = isMobile;
            return this;
        }

        public NewPageOptions setJavaScriptEnabled(boolean javaScriptEnabled) {
            this.javaScriptEnabled = javaScriptEnabled;
            return this;
        }

        public NewPageOptions setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public NewPageOptions setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public NewPageOptions setPermissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public NewPageOptions setProxy(String server) {
            return this.setProxy(new Proxy(server));
        }

        public NewPageOptions setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public NewPageOptions setRecordHarContent(HarContentPolicy recordHarContent) {
            this.recordHarContent = recordHarContent;
            return this;
        }

        public NewPageOptions setRecordHarMode(HarMode recordHarMode) {
            this.recordHarMode = recordHarMode;
            return this;
        }

        public NewPageOptions setRecordHarOmitContent(boolean recordHarOmitContent) {
            this.recordHarOmitContent = recordHarOmitContent;
            return this;
        }

        public NewPageOptions setRecordHarPath(Path recordHarPath) {
            this.recordHarPath = recordHarPath;
            return this;
        }

        public NewPageOptions setRecordHarUrlFilter(String recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public NewPageOptions setRecordHarUrlFilter(Pattern recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public NewPageOptions setRecordVideoDir(Path recordVideoDir) {
            this.recordVideoDir = recordVideoDir;
            return this;
        }

        public NewPageOptions setRecordVideoSize(int width, int height) {
            return this.setRecordVideoSize(new RecordVideoSize(width, height));
        }

        public NewPageOptions setRecordVideoSize(RecordVideoSize recordVideoSize) {
            this.recordVideoSize = recordVideoSize;
            return this;
        }

        public NewPageOptions setReducedMotion(ReducedMotion reducedMotion) {
            this.reducedMotion = reducedMotion;
            return this;
        }

        public NewPageOptions setScreenSize(int width, int height) {
            return this.setScreenSize(new ScreenSize(width, height));
        }

        public NewPageOptions setScreenSize(ScreenSize screenSize) {
            this.screenSize = screenSize;
            return this;
        }

        public NewPageOptions setServiceWorkers(ServiceWorkerPolicy serviceWorkers) {
            this.serviceWorkers = serviceWorkers;
            return this;
        }

        public NewPageOptions setStorageState(String storageState) {
            this.storageState = storageState;
            return this;
        }

        public NewPageOptions setStorageStatePath(Path storageStatePath) {
            this.storageStatePath = storageStatePath;
            return this;
        }

        public NewPageOptions setStrictSelectors(boolean strictSelectors) {
            this.strictSelectors = strictSelectors;
            return this;
        }

        public NewPageOptions setTimezoneId(String timezoneId) {
            this.timezoneId = timezoneId;
            return this;
        }

        public NewPageOptions setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public NewPageOptions setViewportSize(int width, int height) {
            return this.setViewportSize(new ViewportSize(width, height));
        }

        public NewPageOptions setViewportSize(ViewportSize viewportSize) {
            this.viewportSize = Optional.ofNullable(viewportSize);
            return this;
        }
    }

    public static class NewContextOptions {
        public Boolean acceptDownloads;
        public String baseURL;
        public Boolean bypassCSP;
        public ColorScheme colorScheme;
        public Double deviceScaleFactor;
        public Map<String, String> extraHTTPHeaders;
        public ForcedColors forcedColors;
        public Geolocation geolocation;
        public Boolean hasTouch;
        public HttpCredentials httpCredentials;
        public Boolean ignoreHTTPSErrors;
        public Boolean isMobile;
        public Boolean javaScriptEnabled;
        public String locale;
        public Boolean offline;
        public List<String> permissions;
        public Proxy proxy;
        public HarContentPolicy recordHarContent;
        public HarMode recordHarMode;
        public Boolean recordHarOmitContent;
        public Path recordHarPath;
        public Object recordHarUrlFilter;
        public Path recordVideoDir;
        public RecordVideoSize recordVideoSize;
        public ReducedMotion reducedMotion;
        public ScreenSize screenSize;
        public ServiceWorkerPolicy serviceWorkers;
        public String storageState;
        public Path storageStatePath;
        public Boolean strictSelectors;
        public String timezoneId;
        public String userAgent;
        public Optional<ViewportSize> viewportSize;

        public NewContextOptions setAcceptDownloads(boolean acceptDownloads) {
            this.acceptDownloads = acceptDownloads;
            return this;
        }

        public NewContextOptions setBaseURL(String baseURL) {
            this.baseURL = baseURL;
            return this;
        }

        public NewContextOptions setBypassCSP(boolean bypassCSP) {
            this.bypassCSP = bypassCSP;
            return this;
        }

        public NewContextOptions setColorScheme(ColorScheme colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        public NewContextOptions setDeviceScaleFactor(double deviceScaleFactor) {
            this.deviceScaleFactor = deviceScaleFactor;
            return this;
        }

        public NewContextOptions setExtraHTTPHeaders(Map<String, String> extraHTTPHeaders) {
            this.extraHTTPHeaders = extraHTTPHeaders;
            return this;
        }

        public NewContextOptions setForcedColors(ForcedColors forcedColors) {
            this.forcedColors = forcedColors;
            return this;
        }

        public NewContextOptions setGeolocation(double latitude, double longitude) {
            return this.setGeolocation(new Geolocation(latitude, longitude));
        }

        public NewContextOptions setGeolocation(Geolocation geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public NewContextOptions setHasTouch(boolean hasTouch) {
            this.hasTouch = hasTouch;
            return this;
        }

        public NewContextOptions setHttpCredentials(String username, String password) {
            return this.setHttpCredentials(new HttpCredentials(username, password));
        }

        public NewContextOptions setHttpCredentials(HttpCredentials httpCredentials) {
            this.httpCredentials = httpCredentials;
            return this;
        }

        public NewContextOptions setIgnoreHTTPSErrors(boolean ignoreHTTPSErrors) {
            this.ignoreHTTPSErrors = ignoreHTTPSErrors;
            return this;
        }

        public NewContextOptions setIsMobile(boolean isMobile) {
            this.isMobile = isMobile;
            return this;
        }

        public NewContextOptions setJavaScriptEnabled(boolean javaScriptEnabled) {
            this.javaScriptEnabled = javaScriptEnabled;
            return this;
        }

        public NewContextOptions setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public NewContextOptions setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public NewContextOptions setPermissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public NewContextOptions setProxy(String server) {
            return this.setProxy(new Proxy(server));
        }

        public NewContextOptions setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public NewContextOptions setRecordHarContent(HarContentPolicy recordHarContent) {
            this.recordHarContent = recordHarContent;
            return this;
        }

        public NewContextOptions setRecordHarMode(HarMode recordHarMode) {
            this.recordHarMode = recordHarMode;
            return this;
        }

        public NewContextOptions setRecordHarOmitContent(boolean recordHarOmitContent) {
            this.recordHarOmitContent = recordHarOmitContent;
            return this;
        }

        public NewContextOptions setRecordHarPath(Path recordHarPath) {
            this.recordHarPath = recordHarPath;
            return this;
        }

        public NewContextOptions setRecordHarUrlFilter(String recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public NewContextOptions setRecordHarUrlFilter(Pattern recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public NewContextOptions setRecordVideoDir(Path recordVideoDir) {
            this.recordVideoDir = recordVideoDir;
            return this;
        }

        public NewContextOptions setRecordVideoSize(int width, int height) {
            return this.setRecordVideoSize(new RecordVideoSize(width, height));
        }

        public NewContextOptions setRecordVideoSize(RecordVideoSize recordVideoSize) {
            this.recordVideoSize = recordVideoSize;
            return this;
        }

        public NewContextOptions setReducedMotion(ReducedMotion reducedMotion) {
            this.reducedMotion = reducedMotion;
            return this;
        }

        public NewContextOptions setScreenSize(int width, int height) {
            return this.setScreenSize(new ScreenSize(width, height));
        }

        public NewContextOptions setScreenSize(ScreenSize screenSize) {
            this.screenSize = screenSize;
            return this;
        }

        public NewContextOptions setServiceWorkers(ServiceWorkerPolicy serviceWorkers) {
            this.serviceWorkers = serviceWorkers;
            return this;
        }

        public NewContextOptions setStorageState(String storageState) {
            this.storageState = storageState;
            return this;
        }

        public NewContextOptions setStorageStatePath(Path storageStatePath) {
            this.storageStatePath = storageStatePath;
            return this;
        }

        public NewContextOptions setStrictSelectors(boolean strictSelectors) {
            this.strictSelectors = strictSelectors;
            return this;
        }

        public NewContextOptions setTimezoneId(String timezoneId) {
            this.timezoneId = timezoneId;
            return this;
        }

        public NewContextOptions setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public NewContextOptions setViewportSize(int width, int height) {
            return this.setViewportSize(new ViewportSize(width, height));
        }

        public NewContextOptions setViewportSize(ViewportSize viewportSize) {
            this.viewportSize = Optional.ofNullable(viewportSize);
            return this;
        }
    }
}

