/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.CommandLineConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.config.SystemPropertyConfigurator;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.CompcConfiguration;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.BuilderLogger;
import flex2.tools.oem.internal.LibraryCompilerConfiguration;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMConsole;
import flex2.tools.oem.internal.OEMLogAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.clients.COMPJSC;
import org.apache.royale.compiler.clients.MXMLJSC;

public class OEMUtil {
    public static final void init(Logger logger, MimeMappings mimeMappings, ProgressMeter meter, PathResolver resolver, CompilerControl cc) {
        ThreadLocalToolkit.setLogger(new OEMLogAdapter(logger));
        ThreadLocalToolkit.setMimeMappings(mimeMappings);
        ThreadLocalToolkit.setProgressMeter(meter);
        ThreadLocalToolkit.setCompilerControl(cc);
    }

    public static final void clean() {
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setMimeMappings(null);
        ThreadLocalToolkit.setProgressMeter(null);
        ThreadLocalToolkit.setCompilerControl(null);
        ThreadLocalToolkit.setCompatibilityVersion(null);
    }

    public static final OEMConfiguration getApplicationConfiguration(String[] args, boolean keepLinkReport, boolean keepSizeReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings) {
        return OEMUtil.getApplicationConfiguration(args, keepLinkReport, keepSizeReport, logger, resolver, mimeMappings, true);
    }

    public static final OEMConfiguration getApplicationConfiguration(String[] args, boolean keepLinkReport, boolean keepSizeReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings, boolean processDefaults) {
        if (!processDefaults) {
            return new OEMConfiguration(null, null);
        }
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(ApplicationCompilerConfiguration.class, ApplicationCompilerConfiguration.getAliases());
            cfgbuf.setDefaultVar("--file-specs");
            DefaultsConfigurator.loadDefaults(cfgbuf);
            MXMLJSC mxmlc = new MXMLJSC();
            mxmlc.configure(args);
            ApplicationCompilerConfiguration configuration = OEMUtil.processMXMLCConfiguration(mxmlc.config);
            configuration.keepLinkReport(keepLinkReport);
            configuration.keepSizeReport(keepSizeReport);
            return new OEMConfiguration(cfgbuf, configuration);
        }
        catch (ConfigurationException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            try {
                Class<?> c = Class.forName("flex.messaging.config.ConfigurationException");
                if (c.isInstance(ex)) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    private static ApplicationCompilerConfiguration processMXMLCConfiguration(org.apache.royale.compiler.config.Configuration config) {
        ApplicationCompilerConfiguration acc = new ApplicationCompilerConfiguration();
        ConfigurationPathResolver resolver = new ConfigurationPathResolver();
        acc.setConfigPathResolver(resolver);
        acc.setBackgroundColor(config.getDefaultBackgroundColor());
        acc.setDebug(config.debug());
        acc.setFrameRate(config.getDefaultFrameRate());
        acc.setHeight(Integer.toString(config.getDefaultHeight()));
        acc.setWidth(Integer.toString(config.getDefaultWidth()));
        acc.setSwfVersion(config.getSwfVersion());
        acc.setScriptRecursionLimit(config.getScriptRecursionLimit());
        acc.setScriptTimeLimit(config.getScriptTimeLimit());
        CompilerConfiguration cc = acc.getCompilerConfiguration();
        cc.setAccessible(config.getCompilerAccessible());
        List externalLibraries = config.getCompilerExternalLibraryPath();
        String[] extlibs = new String[externalLibraries.size()];
        externalLibraries.toArray(extlibs);
        try {
            cc.cfgExternalLibraryPath(null, extlibs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        List libraries = config.getCompilerLibraryPath();
        String[] libs = new String[libraries.size()];
        libraries.toArray(libs);
        try {
            cc.cfgLibraryPath(null, libs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        List sources = config.getCompilerSourcePath();
        String[] srcs = new String[sources.size()];
        sources.toArray(srcs);
        try {
            cc.cfgSourcePath(null, srcs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return acc;
    }

    private static LibraryCompilerConfiguration processCOMPCCConfiguration(org.apache.royale.compiler.config.Configuration config) {
        LibraryCompilerConfiguration acc = new LibraryCompilerConfiguration();
        ConfigurationPathResolver resolver = new ConfigurationPathResolver();
        acc.setConfigPathResolver(resolver);
        acc.setBackgroundColor(config.getDefaultBackgroundColor());
        acc.setDebug(config.debug());
        acc.setFrameRate(config.getDefaultFrameRate());
        acc.setHeight(Integer.toString(config.getDefaultHeight()));
        acc.setWidth(Integer.toString(config.getDefaultWidth()));
        acc.setSwfVersion(config.getSwfVersion());
        acc.setScriptRecursionLimit(config.getScriptRecursionLimit());
        acc.setScriptTimeLimit(config.getScriptTimeLimit());
        CompilerConfiguration cc = acc.getCompilerConfiguration();
        List externalLibraries = config.getCompilerExternalLibraryPath();
        String[] extlibs = new String[externalLibraries.size()];
        externalLibraries.toArray(extlibs);
        try {
            cc.cfgExternalLibraryPath(null, extlibs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        List libraries = config.getCompilerLibraryPath();
        String[] libs = new String[libraries.size()];
        libraries.toArray(libs);
        try {
            cc.cfgLibraryPath(null, libs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        List sources = config.getCompilerSourcePath();
        String[] srcs = new String[sources.size()];
        sources.toArray(srcs);
        try {
            cc.cfgSourcePath(null, srcs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return acc;
    }

    public static final OEMConfiguration getLibraryConfiguration(String[] args, boolean keepLinkReport, boolean keepSizeReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings) {
        return OEMUtil.getLibraryConfiguration(args, keepLinkReport, keepSizeReport, logger, resolver, mimeMappings, true);
    }

    public static final OEMConfiguration getLibraryConfiguration(String[] args, boolean keepLinkReport, boolean keepSizeReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings, boolean processDefaults) {
        if (!processDefaults) {
            return new OEMConfiguration(null, null);
        }
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(LibraryCompilerConfiguration.class, LibraryCompilerConfiguration.getAliases());
            DefaultsConfigurator.loadOEMCompcDefaults(cfgbuf);
            COMPJSC compc = new COMPJSC();
            compc.configure(args);
            LibraryCompilerConfiguration configuration = OEMUtil.processCOMPCCConfiguration(compc.config);
            configuration.keepLinkReport(keepLinkReport);
            configuration.keepSizeReport(keepSizeReport);
            return new OEMConfiguration(cfgbuf, configuration);
        }
        catch (ConfigurationException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            try {
                Class<?> c = Class.forName("flex.messaging.config.ConfigurationException");
                if (c.isInstance(ex)) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    public static final OEMConfiguration getLinkerConfiguration(String[] args, boolean keepLinkReport, boolean keepSizeReport, Logger logger, MimeMappings mimeMappings, PathResolver resolver, Configuration c, Set newLinkerOptions, Set<String> includes, Set<String> excludes) {
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(ApplicationCompilerConfiguration.class, ApplicationCompilerConfiguration.getAliases());
            cfgbuf.setDefaultVar("--file-specs");
            DefaultsConfigurator.loadDefaults(cfgbuf);
            MXMLJSC mxmlc = new MXMLJSC();
            mxmlc.configure(args);
            ApplicationCompilerConfiguration configuration = OEMUtil.processMXMLCConfiguration(mxmlc.config);
            configuration.keepLinkReport(keepLinkReport);
            configuration.keepSizeReport(keepSizeReport);
            return new OEMConfiguration(cfgbuf, configuration);
        }
        catch (ConfigurationException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            try {
                Class<?> cls = Class.forName("flex.messaging.config.ConfigurationException");
                if (cls.isInstance(ex)) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    public static final ConfigurationBuffer getCommandLineConfigurationBuffer(Logger logger, PathResolver resolver, String[] args) {
        ConfigurationBuffer cfgbuf = null;
        try {
            OEMUtil.init(logger, null, null, resolver, null);
            cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, CommandLineConfiguration.getAliases());
            SystemPropertyConfigurator.load(cfgbuf, "flex");
            CommandLineConfigurator.parse(cfgbuf, null, args);
        }
        catch (ConfigurationException ex) {
            ThreadLocalToolkit.log(ex);
            cfgbuf = null;
        }
        return cfgbuf;
    }

    public static final ConfigurationBuffer getCompcConfigurationBuffer(Logger logger, PathResolver resolver, String[] args) {
        ConfigurationBuffer cfgbuf = null;
        try {
            OEMUtil.init(logger, null, null, resolver, null);
            cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
            SystemPropertyConfigurator.load(cfgbuf, "flex");
            CommandLineConfigurator.parse(cfgbuf, null, args);
        }
        catch (ConfigurationException ex) {
            ThreadLocalToolkit.log(ex);
            cfgbuf = null;
        }
        return cfgbuf;
    }

    public static String[] trim(String[] args, ConfigurationBuffer cfgbuf, Set excludes) {
        List<Object[]> positions = cfgbuf.getPositions();
        ArrayList<String> newArgs = new ArrayList<String>();
        int length = positions.size();
        for (int i = 0; i < length; ++i) {
            Object[] a = positions.get(i);
            String var = (String)a[0];
            int iStart = (Integer)a[1];
            int iEnd = (Integer)a[2];
            if (excludes.contains(var)) continue;
            for (int j = iStart; j < iEnd; ++j) {
                newArgs.add(args[j]);
            }
        }
        args = new String[newArgs.size()];
        newArgs.toArray(args);
        return args;
    }

    public static final Logger getLogger(Logger logger, List<Message> messages) {
        return new BuilderLogger(logger == null ? new OEMConsole() : logger, messages);
    }

    public static final String formatConfigurationBuffer(ConfigurationBuffer cfgbuf) {
        return FileConfigurator.formatBuffer(cfgbuf, "royale-config", "flex2.configuration");
    }

    public static final Map getLicenseMap(ToolsConfiguration configuration) {
        return configuration.getLicensesConfiguration().getLicenseMap();
    }
}

