/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.mq;

import java.util.Properties;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.mqtt.ds.mq.MqAdmin;
import org.apache.rocketmq.mqtt.ds.mq.MqConsumer;
import org.apache.rocketmq.mqtt.ds.mq.MqProducer;
import org.apache.rocketmq.mqtt.ds.mq.MqPullConsumer;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public class MqFactory {
    public static synchronized DefaultMQProducer buildDefaultMQProducer(String group, Properties properties) {
        MqProducer mqProducer = new MqProducer(properties);
        mqProducer.setProducerGroup(group);
        return mqProducer.getDefaultMQProducer();
    }

    public static synchronized DefaultMQAdminExt buildDefaultMQAdminExt(String group, Properties properties) {
        MqAdmin mqadmin = new MqAdmin(properties);
        mqadmin.setAdminGroup(group);
        return mqadmin.getDefaultMQAdminExt();
    }

    public static synchronized DefaultMQPushConsumer buildDefaultMQPushConsumer(String group, Properties properties, MessageListener messageListener) {
        MqConsumer mqConsumer = new MqConsumer(properties);
        mqConsumer.setConsumerGroup(group);
        mqConsumer.setMessageListener(messageListener);
        return mqConsumer.getDefaultMQPushConsumer();
    }

    public static synchronized DefaultMQPullConsumer buildDefaultMQPullConsumer(String group, Properties properties) {
        MqPullConsumer mqConsumer = new MqPullConsumer(properties);
        mqConsumer.setConsumerGroup(group);
        return mqConsumer.getDefaultMQPullConsumer();
    }

    public static DefaultMQProducer buildDefaultMQProducer(String group, String nameSrv) {
        MqProducer mqProducer = new MqProducer(nameSrv);
        mqProducer.setProducerGroup(group);
        return mqProducer.getDefaultMQProducer();
    }

    public static DefaultMQPushConsumer buildDefaultMQPushConsumer(String group, String nameSrv, MessageListener messageListener, Properties properties) {
        MqConsumer mqConsumer = new MqConsumer(properties, nameSrv);
        mqConsumer.setConsumerGroup(group);
        mqConsumer.setMessageListener(messageListener);
        return mqConsumer.getDefaultMQPushConsumer();
    }

    public static DefaultMQPullConsumer buildDefaultMQPullConsumer(String group, String nameSrv) {
        MqPullConsumer mqConsumer = new MqPullConsumer(nameSrv);
        mqConsumer.setConsumerGroup(group);
        return mqConsumer.getDefaultMQPullConsumer();
    }

    public static DefaultMQAdminExt buildDefaultMQAdminExt(String group, String nameSrv) {
        MqAdmin mqadmin = new MqAdmin(nameSrv);
        mqadmin.setAdminGroup(group);
        return mqadmin.getDefaultMQAdminExt();
    }
}

