/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent.collection;

import com.alipay.sofa.jraft.rhea.util.concurrent.collection.AbstractEntry;
import com.alipay.sofa.jraft.rhea.util.concurrent.collection.ConcurrentAutoTable;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

public class NonBlockingHashMapLong<TypeV>
extends AbstractMap<Long, TypeV>
implements ConcurrentMap<Long, TypeV>,
Serializable {
    private static final long serialVersionUID = 1234123412341234124L;
    private static Unsafe unsafe;
    private static final int REPROBE_LIMIT = 10;
    private static final int _Obase;
    private static final int _Oscale;
    private static final int _Lbase;
    private static final int _Lscale;
    private static final long _chm_offset;
    private static final long _val_1_offset;
    private transient CHM _chm;
    private transient Object _val_1;
    private transient long _last_resize_milli;
    private final boolean _opt_for_space;
    private static final int MIN_SIZE_LOG = 4;
    private static final int MIN_SIZE = 16;
    private static final Object NO_MATCH_OLD;
    private static final Object MATCH_ANY;
    private static final Object TOMBSTONE;
    private static final Prime TOMBPRIME;
    private static final long NO_KEY = 0L;

    private static long rawIndex(Object[] ary, int idx) {
        assert (idx >= 0 && idx < ary.length);
        return (long)_Obase + (long)idx * (long)_Oscale;
    }

    private static long rawIndex(long[] ary, int idx) {
        assert (idx >= 0 && idx < ary.length);
        return (long)_Lbase + (long)idx * (long)_Lscale;
    }

    private boolean CAS(long offset, Object old, Object nnn) {
        return unsafe.compareAndSwapObject(this, offset, old, nnn);
    }

    public final void print() {
        System.out.println("=========");
        NonBlockingHashMapLong.print_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static void print_impl(int i, long K, Object V) {
        String p = V instanceof Prime ? "prime_" : "";
        Object V2 = Prime.unbox(V);
        String VS = V2 == TOMBSTONE ? "tombstone" : V2.toString();
        System.out.println("[" + i + "]=(" + K + "," + p + VS + ")");
    }

    private void print2() {
        System.out.println("=========");
        NonBlockingHashMapLong.print2_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static void print2_impl(int i, long K, Object V) {
        if (V != null && Prime.unbox(V) != TOMBSTONE) {
            NonBlockingHashMapLong.print_impl(i, K, V);
        }
    }

    private static int reprobe_limit(int len) {
        return 10 + (len >> 8);
    }

    public NonBlockingHashMapLong() {
        this(16, true);
    }

    public NonBlockingHashMapLong(int initial_sz) {
        this(initial_sz, true);
    }

    public NonBlockingHashMapLong(boolean opt_for_space) {
        this(1, opt_for_space);
    }

    public NonBlockingHashMapLong(int initial_sz, boolean opt_for_space) {
        this._opt_for_space = opt_for_space;
        this.initialize(initial_sz);
    }

    private void initialize(int initial_sz) {
        if (initial_sz < 0) {
            throw new IllegalArgumentException();
        }
        int i = 4;
        while (1 << i < initial_sz) {
            ++i;
        }
        this._chm = new CHM(this, new ConcurrentAutoTable(), i);
        this._val_1 = TOMBSTONE;
        this._last_resize_milli = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (this._val_1 == TOMBSTONE ? 0 : 1) + this._chm.size();
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public boolean contains(Object val) {
        return this.containsValue(val);
    }

    @Override
    public TypeV put(long key, TypeV val) {
        return this.putIfMatch(key, val, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(long key, TypeV val) {
        return this.putIfMatch(key, val, TOMBSTONE);
    }

    public TypeV remove(long key) {
        return this.putIfMatch(key, TOMBSTONE, NO_MATCH_OLD);
    }

    public boolean remove(long key, Object val) {
        return this.putIfMatch(key, TOMBSTONE, val) == val;
    }

    @Override
    public TypeV replace(long key, TypeV val) {
        return this.putIfMatch(key, val, MATCH_ANY);
    }

    @Override
    public boolean replace(long key, TypeV oldValue, TypeV newValue) {
        return this.putIfMatch(key, newValue, oldValue) == oldValue;
    }

    private TypeV putIfMatch(long key, Object newVal, Object oldVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        if (key == 0L) {
            Object curVal = this._val_1;
            if ((oldVal == NO_MATCH_OLD || curVal == oldVal || oldVal == MATCH_ANY && curVal != TOMBSTONE || oldVal.equals(curVal)) && !this.CAS(_val_1_offset, curVal, newVal)) {
                curVal = this._val_1;
            }
            return (TypeV)(curVal == TOMBSTONE ? null : curVal);
        }
        Object res = this._chm.putIfMatch(key, newVal, oldVal);
        assert (!(res instanceof Prime));
        assert (res != null);
        return (TypeV)(res == TOMBSTONE ? null : res);
    }

    @Override
    public void clear() {
        CHM newchm = new CHM(this, new ConcurrentAutoTable(), 4);
        while (!this.CAS(_chm_offset, this._chm, newchm)) {
        }
        this.CAS(_val_1_offset, this._val_1, TOMBSTONE);
    }

    @Override
    public boolean containsValue(Object val) {
        if (val == null) {
            return false;
        }
        if (val == this._val_1) {
            return true;
        }
        for (TypeV V : this.values()) {
            if (V != val && !V.equals(val)) continue;
            return true;
        }
        return false;
    }

    public final TypeV get(long key) {
        if (key == 0L) {
            Object V = this._val_1;
            return (TypeV)(V == TOMBSTONE ? null : V);
        }
        Object V = this._chm.get_impl(key);
        assert (!(V instanceof Prime));
        assert (V != TOMBSTONE);
        return (TypeV)V;
    }

    @Override
    public TypeV get(Object key) {
        return key instanceof Long ? (TypeV)this.get((Long)key) : null;
    }

    @Override
    public TypeV remove(Object key) {
        return key instanceof Long ? (TypeV)this.remove((Long)key) : null;
    }

    @Override
    public boolean remove(Object key, Object Val) {
        return key instanceof Long && this.remove((Long)key, Val);
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof Long && this.containsKey((Long)key);
    }

    @Override
    public TypeV putIfAbsent(Long key, TypeV val) {
        return this.putIfAbsent((long)key, val);
    }

    @Override
    public TypeV replace(Long key, TypeV Val) {
        return this.replace((long)key, Val);
    }

    @Override
    public TypeV put(Long key, TypeV val) {
        return this.put((long)key, val);
    }

    @Override
    public boolean replace(Long key, TypeV oldValue, TypeV newValue) {
        return this.replace((long)key, oldValue, newValue);
    }

    private void help_copy() {
        CHM topchm = this._chm;
        if (topchm._newchm == null) {
            return;
        }
        topchm.help_copy_impl(false);
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object v) {
                return NonBlockingHashMapLong.this.containsValue(v);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<Long> keys() {
        return new IteratorLong();
    }

    @Override
    public Set<Long> keySet() {
        return new AbstractSet<Long>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object k) {
                return NonBlockingHashMapLong.this.containsKey(k);
            }

            @Override
            public boolean remove(Object k) {
                return NonBlockingHashMapLong.this.remove(k) != null;
            }

            public IteratorLong iterator() {
                return new IteratorLong();
            }
        };
    }

    public long[] keySetLong() {
        long[] dom = new long[this.size()];
        IteratorLong i = (IteratorLong)this.keySet().iterator();
        int j = 0;
        while (j < dom.length && i.hasNext()) {
            dom[j++] = i.nextLong();
        }
        return dom;
    }

    @Override
    public Set<Map.Entry<Long, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<Long, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return NonBlockingHashMapLong.this.remove(e.getKey(), e.getValue());
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object v = NonBlockingHashMapLong.this.get(e.getKey());
                return v.equals(e.getValue());
            }

            @Override
            public Iterator<Map.Entry<Long, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (long K : this.keySet()) {
            TypeV V = this.get(K);
            s.writeLong(K);
            s.writeObject(V);
        }
        s.writeLong(0L);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initialize(16);
        while (true) {
            long K = s.readLong();
            Object V = s.readObject();
            if (K == 0L && V == null) break;
            this.put(K, (TypeV)V);
        }
    }

    static {
        Field f;
        unsafe = UnsafeUtil.getUnsafeAccessor().getUnsafe();
        _Obase = unsafe.arrayBaseOffset(Object[].class);
        _Oscale = unsafe.arrayIndexScale(Object[].class);
        _Lbase = unsafe.arrayBaseOffset(long[].class);
        _Lscale = unsafe.arrayIndexScale(long[].class);
        try {
            f = NonBlockingHashMapLong.class.getDeclaredField("_chm");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        _chm_offset = unsafe.objectFieldOffset(f);
        try {
            f = NonBlockingHashMapLong.class.getDeclaredField("_val_1");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        _val_1_offset = unsafe.objectFieldOffset(f);
        NO_MATCH_OLD = new Object();
        MATCH_ANY = new Object();
        TOMBSTONE = new Object();
        TOMBPRIME = new Prime(TOMBSTONE);
    }

    private class SnapshotE
    implements Iterator<Map.Entry<Long, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Map.Entry<Long, TypeV> next() {
            this._ss.next();
            return new NBHMLEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMLEntry
    extends AbstractEntry<Long, TypeV> {
        NBHMLEntry(Long k, TypeV v) {
            super(k, v);
        }

        @Override
        public TypeV setValue(TypeV val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this._val = val;
            return NonBlockingHashMapLong.this.put((Long)this._key, val);
        }
    }

    public class IteratorLong
    implements Iterator<Long>,
    Enumeration<Long> {
        private final SnapshotV _ss;

        public IteratorLong() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Long next() {
            this._ss.next();
            return this._ss._prevK;
        }

        public long nextLong() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public Long nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotV
    implements Iterator<TypeV>,
    Enumeration<TypeV> {
        final CHM _sschm;
        private int _idx;
        private long _nextK;
        private long _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            CHM topchm;
            while (true) {
                topchm = NonBlockingHashMapLong.this._chm;
                if (topchm._newchm == null) break;
                topchm.help_copy_impl(true);
            }
            this._sschm = topchm;
            this._idx = -1;
            this.next();
        }

        int length() {
            return this._sschm._keys.length;
        }

        long key(int idx) {
            return this._sschm._keys[idx];
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != -1 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            if (this._idx == -1) {
                this._idx = 0;
                this._nextK = 0L;
                this._nextV = NonBlockingHashMapLong.this.get(this._nextK);
                if (this._nextV != null) {
                    return this._prevV;
                }
            }
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == 0L || (this._nextV = NonBlockingHashMapLong.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        @Override
        public void remove() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            this._sschm.putIfMatch(this._prevK, TOMBSTONE, this._prevV);
            this._prevV = null;
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM
    implements Serializable {
        private static final long serialVersionUID = 4958597092775229086L;
        final NonBlockingHashMapLong _nbhml;
        private final ConcurrentAutoTable _size;
        private final ConcurrentAutoTable _slots;
        volatile CHM _newchm;
        private static final AtomicReferenceFieldUpdater<CHM, CHM> _newchmUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, CHM.class, "_newchm");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        final long[] _keys;
        final Object[] _vals;
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newchm(CHM newchm) {
            return _newchmUpdater.compareAndSet(this, null, newchm);
        }

        private boolean CAS_key(int idx, long old, long key) {
            return unsafe.compareAndSwapLong(this._keys, NonBlockingHashMapLong.rawIndex(this._keys, idx), old, key);
        }

        private boolean CAS_val(int idx, Object old, Object val) {
            return unsafe.compareAndSwapObject(this._vals, NonBlockingHashMapLong.rawIndex(this._vals, idx), old, val);
        }

        CHM(NonBlockingHashMapLong nbhml, ConcurrentAutoTable size, int logsize) {
            this._nbhml = nbhml;
            this._size = size;
            this._slots = new ConcurrentAutoTable();
            this._keys = new long[1 << logsize];
            this._vals = new Object[1 << logsize];
        }

        private void print() {
            for (int i = 0; i < this._keys.length; ++i) {
                long K = this._keys[i];
                if (K == 0L) continue;
                NonBlockingHashMapLong.print_impl(i, K, this._vals[i]);
            }
            CHM newchm = this._newchm;
            if (newchm != null) {
                System.out.println("----");
                newchm.print();
            }
        }

        private void print2() {
            for (int i = 0; i < this._keys.length; ++i) {
                long K = this._keys[i];
                if (K == 0L) continue;
                NonBlockingHashMapLong.print2_impl(i, K, this._vals[i]);
            }
            CHM newchm = this._newchm;
            if (newchm != null) {
                System.out.println("----");
                newchm.print2();
            }
        }

        private Object get_impl(long key) {
            int len = this._keys.length;
            int idx = (int)(key & (long)(len - 1));
            int reprobe_cnt = 0;
            while (true) {
                long K = this._keys[idx];
                Object V = this._vals[idx];
                if (K == 0L) {
                    return null;
                }
                if (key == K) {
                    if (!(V instanceof Prime)) {
                        if (V == TOMBSTONE) {
                            return null;
                        }
                        CHM newchm = this._newchm;
                        return V;
                    }
                    return this.copy_slot_and_check(idx, key).get_impl(key);
                }
                if (++reprobe_cnt >= NonBlockingHashMapLong.reprobe_limit(len)) {
                    return this._newchm == null ? null : this.copy_slot_and_check(idx, key).get_impl(key);
                }
                idx = idx + 1 & len - 1;
            }
        }

        private Object putIfMatch(long key, Object putval, Object expVal) {
            Object V;
            assert (putval != null);
            assert (!(putval instanceof Prime));
            assert (!(expVal instanceof Prime));
            int len = this._keys.length;
            int idx = (int)(key & (long)(len - 1));
            int reprobe_cnt = 0;
            while (true) {
                V = this._vals[idx];
                long K = this._keys[idx];
                if (K == 0L) {
                    if (putval == TOMBSTONE) {
                        return putval;
                    }
                    if (this.CAS_key(idx, 0L, key)) {
                        this._slots.add(1L);
                        break;
                    }
                    K = this._keys[idx];
                    assert (K != 0L);
                }
                if (K == key) break;
                if (++reprobe_cnt >= NonBlockingHashMapLong.reprobe_limit(len)) {
                    CHM newchm = this.resize();
                    if (expVal != null) {
                        this._nbhml.help_copy();
                    }
                    return newchm.putIfMatch(key, putval, expVal);
                }
                idx = idx + 1 & len - 1;
            }
            if (putval == V) {
                return V;
            }
            if (V == null && this.tableFull(reprobe_cnt, len) || V instanceof Prime) {
                this.resize();
                return this.copy_slot_and_check(idx, expVal).putIfMatch(key, putval, expVal);
            }
            if (!(expVal == NO_MATCH_OLD || V == expVal || expVal == MATCH_ANY && V != TOMBSTONE && V != null || V == null && expVal == TOMBSTONE || expVal != null && expVal.equals(V))) {
                return V;
            }
            if (this.CAS_val(idx, V, putval)) {
                if (expVal != null) {
                    if ((V == null || V == TOMBSTONE) && putval != TOMBSTONE) {
                        this._size.add(1L);
                    }
                    if (V != null && V != TOMBSTONE && putval == TOMBSTONE) {
                        this._size.add(-1L);
                    }
                }
            } else {
                V = this._vals[idx];
                if (V instanceof Prime) {
                    return this.copy_slot_and_check(idx, expVal).putIfMatch(key, putval, expVal);
                }
            }
            return V == null && expVal != null ? TOMBSTONE : V;
        }

        private boolean tableFull(int reprobe_cnt, int len) {
            return reprobe_cnt >= 10 && this._slots.estimate_get() >= (long)(NonBlockingHashMapLong.reprobe_limit(len) * 2);
        }

        private CHM resize() {
            int sz;
            CHM newchm = this._newchm;
            if (newchm != null) {
                return newchm;
            }
            int oldlen = this._keys.length;
            int newsz = sz = this.size();
            if (this._nbhml._opt_for_space) {
                if (sz >= oldlen >> 1) {
                    newsz = oldlen << 1;
                }
            } else if (sz >= oldlen >> 2) {
                newsz = oldlen << 1;
                if (sz >= oldlen >> 1) {
                    newsz = oldlen << 2;
                }
            }
            long tm = System.currentTimeMillis();
            if (newsz <= oldlen && tm <= this._nbhml._last_resize_milli + 10000L) {
                newsz = oldlen << 1;
            }
            if (newsz < oldlen) {
                newsz = oldlen;
            }
            int log2 = 4;
            while (1 << log2 < newsz) {
                ++log2;
            }
            long r = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, r, r + 1L)) {
                r = this._resizers;
            }
            int megs = (1 << log2 << 1) + 4 << 3 >> 20;
            if (r >= 2L && megs > 0) {
                newchm = this._newchm;
                if (newchm != null) {
                    return newchm;
                }
                try {
                    Thread.sleep(8L * (long)megs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((newchm = this._newchm) != null) {
                return newchm;
            }
            newchm = new CHM(this._nbhml, this._size, log2);
            if (this._newchm != null) {
                return this._newchm;
            }
            if (!this.CAS_newchm(newchm)) {
                newchm = this._newchm;
            }
            return newchm;
        }

        private void help_copy_impl(boolean copy_all) {
            CHM newchm = this._newchm;
            assert (newchm != null);
            int oldlen = this._keys.length;
            int MIN_COPY_WORK = Math.min(oldlen, 1024);
            int panic_start = -1;
            int copyidx = -9999;
            while (this._copyDone < (long)oldlen) {
                if (panic_start == -1) {
                    copyidx = (int)this._copyIdx;
                    while (copyidx < oldlen << 1 && !_copyIdxUpdater.compareAndSet(this, copyidx, copyidx + MIN_COPY_WORK)) {
                        copyidx = (int)this._copyIdx;
                    }
                    if (copyidx >= oldlen << 1) {
                        panic_start = copyidx;
                    }
                }
                int workdone = 0;
                for (int i = 0; i < MIN_COPY_WORK; ++i) {
                    if (!this.copy_slot(copyidx + i & oldlen - 1)) continue;
                    ++workdone;
                }
                if (workdone > 0) {
                    this.copy_check_and_promote(workdone);
                }
                copyidx += MIN_COPY_WORK;
                if (copy_all || panic_start != -1) continue;
                return;
            }
            this.copy_check_and_promote(0);
        }

        private CHM copy_slot_and_check(int idx, Object should_help) {
            assert (this._newchm != null);
            if (this.copy_slot(idx)) {
                this.copy_check_and_promote(1);
            }
            if (should_help != null) {
                this._nbhml.help_copy();
            }
            return this._newchm;
        }

        private void copy_check_and_promote(int workdone) {
            int oldlen = this._keys.length;
            long copyDone = this._copyDone;
            long nowDone = copyDone + (long)workdone;
            assert (nowDone <= (long)oldlen);
            if (workdone > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, copyDone, nowDone)) {
                    copyDone = this._copyDone;
                    nowDone = copyDone + (long)workdone;
                    assert (nowDone <= (long)oldlen);
                }
            }
            if (nowDone == (long)oldlen && this._nbhml._chm == this && this._nbhml.CAS(_chm_offset, this, this._newchm)) {
                this._nbhml._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(int idx) {
            boolean copied_into_new;
            long key;
            while ((key = this._keys[idx]) == 0L) {
                this.CAS_key(idx, 0L, idx + this._keys.length);
            }
            Object oldval = this._vals[idx];
            while (!(oldval instanceof Prime)) {
                Prime box;
                Prime prime = box = oldval == null || oldval == TOMBSTONE ? TOMBPRIME : new Prime(oldval);
                if (this.CAS_val(idx, oldval, box)) {
                    if (box == TOMBPRIME) {
                        return true;
                    }
                    oldval = box;
                    break;
                }
                oldval = this._vals[idx];
            }
            if (oldval == TOMBPRIME) {
                return false;
            }
            Object old_unboxed = ((Prime)oldval)._V;
            assert (old_unboxed != TOMBSTONE);
            boolean bl = copied_into_new = this._newchm.putIfMatch(key, old_unboxed, null) == null;
            while (!this.CAS_val(idx, oldval, TOMBPRIME)) {
                oldval = this._vals[idx];
            }
            return copied_into_new;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object V) {
            this._V = V;
        }

        static Object unbox(Object V) {
            return V instanceof Prime ? ((Prime)V)._V : V;
        }
    }
}

