/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.util.concurrent.collection.NonBlockingHashMap;
import com.alipay.sofa.jraft.rhea.util.concurrent.collection.NonBlockingHashMapLong;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Maps {
    private static final boolean USE_NON_BLOCKING_HASH = SystemPropertyUtil.getBoolean((String)"rhea.use.non_blocking_hash", (boolean)true);

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMapWithExpectedSize(int expectedSize) {
        return new IdentityHashMap(Maps.capacity(expectedSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        if (USE_NON_BLOCKING_HASH && UnsafeUtil.hasUnsafe()) {
            return new NonBlockingHashMap();
        }
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        if (USE_NON_BLOCKING_HASH && UnsafeUtil.hasUnsafe()) {
            return new NonBlockingHashMap(initialCapacity);
        }
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <V> ConcurrentMap<Long, V> newConcurrentMapLong() {
        if (USE_NON_BLOCKING_HASH && UnsafeUtil.hasUnsafe()) {
            return new NonBlockingHashMapLong();
        }
        return new ConcurrentHashMap();
    }

    public static <V> ConcurrentMap<Long, V> newConcurrentMapLong(int initialCapacity) {
        if (USE_NON_BLOCKING_HASH) {
            return new NonBlockingHashMapLong(initialCapacity);
        }
        return new ConcurrentHashMap(initialCapacity);
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Requires.requireTrue((expectedSize >= 0 ? 1 : 0) != 0, (Object)("expectedSize cannot be negative but was: " + expectedSize));
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    private Maps() {
    }
}

