/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace.hook;

import java.util.ArrayList;
import org.apache.rocketmq.client.hook.EndTransactionContext;
import org.apache.rocketmq.client.hook.EndTransactionHook;
import org.apache.rocketmq.client.trace.AsyncTraceDispatcher;
import org.apache.rocketmq.client.trace.TraceBean;
import org.apache.rocketmq.client.trace.TraceContext;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.TraceType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageType;
import org.apache.rocketmq.common.protocol.NamespaceUtil;

public class EndTransactionTraceHookImpl
implements EndTransactionHook {
    private TraceDispatcher localDispatcher;

    public EndTransactionTraceHookImpl(TraceDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    @Override
    public String hookName() {
        return "EndTransactionTraceHook";
    }

    @Override
    public void endTransaction(EndTransactionContext context) {
        if (context == null || context.getMessage().getTopic().startsWith(((AsyncTraceDispatcher)this.localDispatcher).getTraceTopicName())) {
            return;
        }
        Message msg = context.getMessage();
        TraceContext tuxeContext = new TraceContext();
        tuxeContext.setTraceBeans(new ArrayList<TraceBean>(1));
        tuxeContext.setTraceType(TraceType.EndTransaction);
        tuxeContext.setGroupName(NamespaceUtil.withoutNamespace((String)context.getProducerGroup()));
        TraceBean traceBean = new TraceBean();
        traceBean.setTopic(NamespaceUtil.withoutNamespace((String)context.getMessage().getTopic()));
        traceBean.setTags(context.getMessage().getTags());
        traceBean.setKeys(context.getMessage().getKeys());
        traceBean.setStoreHost(context.getBrokerAddr());
        traceBean.setMsgType(MessageType.Trans_msg_Commit);
        traceBean.setClientHost(((AsyncTraceDispatcher)this.localDispatcher).getHostProducer().getmQClientFactory().getClientId());
        traceBean.setMsgId(context.getMsgId());
        traceBean.setTransactionState(context.getTransactionState());
        traceBean.setTransactionId(context.getTransactionId());
        traceBean.setFromTransactionCheck(context.isFromTransactionCheck());
        String regionId = msg.getProperty("MSG_REGION");
        if (regionId == null || regionId.isEmpty()) {
            regionId = "DefaultRegion";
        }
        tuxeContext.setRegionId(regionId);
        tuxeContext.getTraceBeans().add(traceBean);
        tuxeContext.setTimeStamp(System.currentTimeMillis());
        this.localDispatcher.append(tuxeContext);
    }
}

