/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.util.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import org.apache.rocketmq.util.cache.CacheObject;

public class ExpiredLocalCache<K, T> {
    private ConcurrentLinkedHashMap<K, CacheObject<T>> cache;
    private EvictionListener<K, CacheObject<T>> listener;

    public ExpiredLocalCache(int size) {
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)size).build();
    }

    public ExpiredLocalCache(int size, String name) {
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)size).build();
    }

    public ExpiredLocalCache(int size, boolean memoryMeter, EvictionListener<K, CacheObject<T>> listener) {
        this.listener = listener;
        this.cache = new ConcurrentLinkedHashMap.Builder().listener(listener).maximumWeightedCapacity((long)size).build();
    }

    public T get(K key) {
        CacheObject object = (CacheObject)this.cache.get(key);
        if (object == null) {
            return null;
        }
        Object ret = object.getTarget();
        if (ret == null) {
            this.delete(key);
        }
        return ret;
    }

    public T put(K key, T v, long exp) {
        CacheObject<T> value = new CacheObject<T>(exp, v);
        CacheObject old = (CacheObject)this.cache.put(key, value);
        if (old == null) {
            return null;
        }
        return old.getTarget();
    }

    public T putIfAbsent(K key, T v, long exp) {
        CacheObject<T> value = new CacheObject<T>(exp, v);
        CacheObject old = (CacheObject)this.cache.putIfAbsent(key, value);
        if (old == null) {
            return null;
        }
        return old.getTarget();
    }

    public T delete(K key) {
        CacheObject object = (CacheObject)this.cache.remove(key);
        if (object == null) {
            return null;
        }
        Object ret = object.getTarget();
        return ret;
    }

    public ConcurrentLinkedHashMap<K, CacheObject<T>> getCache() {
        return this.cache;
    }
}

