/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class ConsumerManager {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final List<ConsumerIdsChangeListener> consumerIdsChangeListenerList = new CopyOnWriteArrayList<ConsumerIdsChangeListener>();
    protected final BrokerStatsManager brokerStatsManager;

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = null;
    }

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener, BrokerStatsManager brokerStatsManager) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = brokerStatsManager;
    }

    public ClientChannelInfo findChannel(String group, String clientId) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(clientId);
        }
        return null;
    }

    public SubscriptionData findSubscriptionData(String group, String topic) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findSubscriptionData(topic);
        }
        return null;
    }

    public ConcurrentMap<String, ConsumerGroupInfo> getConsumerTable() {
        return this.consumerTable;
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group) {
        return (ConsumerGroupInfo)this.consumerTable.get(group);
    }

    public int findSubscriptionDataCount(String group) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.getSubscriptionTable().size();
        }
        return 0;
    }

    public boolean doChannelCloseEvent(String remoteAddr, Channel channel) {
        boolean removed = false;
        for (Map.Entry next : this.consumerTable.entrySet()) {
            ConsumerGroupInfo remove;
            ConsumerGroupInfo info = (ConsumerGroupInfo)next.getValue();
            ClientChannelInfo clientChannelInfo = info.doChannelCloseEvent(remoteAddr, channel);
            if (clientChannelInfo == null) continue;
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, (String)next.getKey(), clientChannelInfo, info.getSubscribeTopics());
            if (info.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(next.getKey())) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", next.getKey());
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, (String)next.getKey(), new Object[0]);
            }
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, (String)next.getKey(), info.getAllChannel());
        }
        return removed;
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable) {
        return this.registerConsumer(group, clientChannelInfo, consumeType, messageModel, consumeFromWhere, subList, isNotifyConsumerIdsChangedEnable, true);
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable, boolean updateSubscription) {
        long start = System.currentTimeMillis();
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_REGISTER, group, clientChannelInfo, subList.stream().map(SubscriptionData::getTopic).collect(Collectors.toSet()));
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            consumerGroupInfo = prev != null ? prev : tmp;
        }
        boolean r1 = consumerGroupInfo.updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere);
        boolean r2 = false;
        if (updateSubscription) {
            r2 = consumerGroupInfo.updateSubscription(subList);
        }
        if ((r1 || r2) && isNotifyConsumerIdsChangedEnable) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
        }
        if (null != this.brokerStatsManager) {
            this.brokerStatsManager.incConsumerRegisterTime((int)(System.currentTimeMillis() - start));
        }
        this.callConsumerIdsChangeListener(ConsumerGroupEvent.REGISTER, group, subList);
        return r1 || r2;
    }

    public void unregisterConsumer(String group, ClientChannelInfo clientChannelInfo, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null != consumerGroupInfo) {
            ConsumerGroupInfo remove;
            boolean removed = consumerGroupInfo.unregisterChannel(clientChannelInfo);
            if (removed) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
            }
            if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(group)) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, group, new Object[0]);
            }
            if (isNotifyConsumerIdsChangedEnable) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
            }
        }
    }

    public void scanNotActiveChannel() {
        Iterator it = this.consumerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String group = (String)next.getKey();
            ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)next.getValue();
            ConcurrentMap<Channel, ClientChannelInfo> channelInfoTable = consumerGroupInfo.getChannelInfoTable();
            Iterator itChannel = channelInfoTable.entrySet().iterator();
            while (itChannel.hasNext()) {
                Map.Entry nextChannel = itChannel.next();
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)nextChannel.getValue();
                long diff = System.currentTimeMillis() - clientChannelInfo.getLastUpdateTimestamp();
                if (diff <= 120000L) continue;
                LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable. channel={}, consumerGroup={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)clientChannelInfo.getChannel()), (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
                RemotingUtil.closeChannel((Channel)clientChannelInfo.getChannel());
                itChannel.remove();
            }
            if (!channelInfoTable.isEmpty()) continue;
            LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable, all clear, consumerGroup={}", (Object)group);
            it.remove();
        }
    }

    public HashSet<String> queryTopicConsumeByWho(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            ConcurrentMap<String, SubscriptionData> subscriptionTable = ((ConsumerGroupInfo)entry.getValue()).getSubscriptionTable();
            if (!subscriptionTable.containsKey(topic)) continue;
            groups.add((String)entry.getKey());
        }
        return groups;
    }

    public void appendConsumerIdsChangeListener(ConsumerIdsChangeListener listener) {
        this.consumerIdsChangeListenerList.add(listener);
    }

    protected void callConsumerIdsChangeListener(ConsumerGroupEvent event, String group, Object ... args) {
        for (ConsumerIdsChangeListener listener : this.consumerIdsChangeListenerList) {
            try {
                listener.handle(event, group, args);
            }
            catch (Throwable t) {
                LOGGER.error("err when call consumerIdsChangeListener", t);
            }
        }
    }
}

