/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HVACTemperature implements Message {

  // Properties.
  protected final short temperatureValue;

  public HVACTemperature(short temperatureValue) {
    super();
    this.temperatureValue = temperatureValue;
  }

  public short getTemperatureValue() {
    return temperatureValue;
  }

  public float getTemperatureInCelcius() {
    return (float) ((getTemperatureValue()) / (256F));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HVACTemperature");

    // Simple Field (temperatureValue)
    writeSimpleField("temperatureValue", temperatureValue, writeSignedShort(writeBuffer, 16));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float temperatureInCelcius = getTemperatureInCelcius();
    writeBuffer.writeVirtual("temperatureInCelcius", temperatureInCelcius);

    writeBuffer.popContext("HVACTemperature");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    HVACTemperature _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (temperatureValue)
    lengthInBits += 16;

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static HVACTemperature staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("HVACTemperature");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short temperatureValue = readSimpleField("temperatureValue", readSignedShort(readBuffer, 16));
    float temperatureInCelcius =
        readVirtualField("temperatureInCelcius", float.class, (temperatureValue) / (256F));

    readBuffer.closeContext("HVACTemperature");
    // Create the instance
    HVACTemperature _hVACTemperature;
    _hVACTemperature = new HVACTemperature(temperatureValue);
    return _hVACTemperature;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HVACTemperature)) {
      return false;
    }
    HVACTemperature that = (HVACTemperature) o;
    return (getTemperatureValue() == that.getTemperatureValue()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTemperatureValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
