/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetCOVMultipleSubscription implements Message {

  // Properties.
  protected final BACnetRecipientProcessEnclosed recipient;
  protected final BACnetContextTagBoolean issueConfirmedNotifications;
  protected final BACnetContextTagUnsignedInteger timeRemaining;
  protected final BACnetContextTagUnsignedInteger maxNotificationDelay;
  protected final BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification
      listOfCovSubscriptionSpecification;

  public BACnetCOVMultipleSubscription(
      BACnetRecipientProcessEnclosed recipient,
      BACnetContextTagBoolean issueConfirmedNotifications,
      BACnetContextTagUnsignedInteger timeRemaining,
      BACnetContextTagUnsignedInteger maxNotificationDelay,
      BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification
          listOfCovSubscriptionSpecification) {
    super();
    this.recipient = recipient;
    this.issueConfirmedNotifications = issueConfirmedNotifications;
    this.timeRemaining = timeRemaining;
    this.maxNotificationDelay = maxNotificationDelay;
    this.listOfCovSubscriptionSpecification = listOfCovSubscriptionSpecification;
  }

  public BACnetRecipientProcessEnclosed getRecipient() {
    return recipient;
  }

  public BACnetContextTagBoolean getIssueConfirmedNotifications() {
    return issueConfirmedNotifications;
  }

  public BACnetContextTagUnsignedInteger getTimeRemaining() {
    return timeRemaining;
  }

  public BACnetContextTagUnsignedInteger getMaxNotificationDelay() {
    return maxNotificationDelay;
  }

  public BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification
      getListOfCovSubscriptionSpecification() {
    return listOfCovSubscriptionSpecification;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetCOVMultipleSubscription");

    // Simple Field (recipient)
    writeSimpleField("recipient", recipient, writeComplex(writeBuffer));

    // Simple Field (issueConfirmedNotifications)
    writeSimpleField(
        "issueConfirmedNotifications", issueConfirmedNotifications, writeComplex(writeBuffer));

    // Simple Field (timeRemaining)
    writeSimpleField("timeRemaining", timeRemaining, writeComplex(writeBuffer));

    // Simple Field (maxNotificationDelay)
    writeSimpleField("maxNotificationDelay", maxNotificationDelay, writeComplex(writeBuffer));

    // Simple Field (listOfCovSubscriptionSpecification)
    writeSimpleField(
        "listOfCovSubscriptionSpecification",
        listOfCovSubscriptionSpecification,
        writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetCOVMultipleSubscription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetCOVMultipleSubscription _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (recipient)
    lengthInBits += recipient.getLengthInBits();

    // Simple field (issueConfirmedNotifications)
    lengthInBits += issueConfirmedNotifications.getLengthInBits();

    // Simple field (timeRemaining)
    lengthInBits += timeRemaining.getLengthInBits();

    // Simple field (maxNotificationDelay)
    lengthInBits += maxNotificationDelay.getLengthInBits();

    // Simple field (listOfCovSubscriptionSpecification)
    lengthInBits += listOfCovSubscriptionSpecification.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetCOVMultipleSubscription staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetCOVMultipleSubscription");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetRecipientProcessEnclosed recipient =
        readSimpleField(
            "recipient",
            readComplex(
                () -> BACnetRecipientProcessEnclosed.staticParse(readBuffer, (short) (0)),
                readBuffer));

    BACnetContextTagBoolean issueConfirmedNotifications =
        readSimpleField(
            "issueConfirmedNotifications",
            readComplex(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger timeRemaining =
        readSimpleField(
            "timeRemaining",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagUnsignedInteger maxNotificationDelay =
        readSimpleField(
            "maxNotificationDelay",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification
        listOfCovSubscriptionSpecification =
            readSimpleField(
                "listOfCovSubscriptionSpecification",
                readComplex(
                    () ->
                        BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification.staticParse(
                            readBuffer, (short) (4)),
                    readBuffer));

    readBuffer.closeContext("BACnetCOVMultipleSubscription");
    // Create the instance
    BACnetCOVMultipleSubscription _bACnetCOVMultipleSubscription;
    _bACnetCOVMultipleSubscription =
        new BACnetCOVMultipleSubscription(
            recipient,
            issueConfirmedNotifications,
            timeRemaining,
            maxNotificationDelay,
            listOfCovSubscriptionSpecification);
    return _bACnetCOVMultipleSubscription;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetCOVMultipleSubscription)) {
      return false;
    }
    BACnetCOVMultipleSubscription that = (BACnetCOVMultipleSubscription) o;
    return (getRecipient() == that.getRecipient())
        && (getIssueConfirmedNotifications() == that.getIssueConfirmedNotifications())
        && (getTimeRemaining() == that.getTimeRemaining())
        && (getMaxNotificationDelay() == that.getMaxNotificationDelay())
        && (getListOfCovSubscriptionSpecification() == that.getListOfCovSubscriptionSpecification())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getRecipient(),
        getIssueConfirmedNotifications(),
        getTimeRemaining(),
        getMaxNotificationDelay(),
        getListOfCovSubscriptionSpecification());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
