/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataUserType is the corresponding interface of BACnetConstructedDataUserType
type BACnetConstructedDataUserType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetUserType returns UserType (property field)
	GetUserType() BACnetAccessUserTypeTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetAccessUserTypeTagged
	// IsBACnetConstructedDataUserType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataUserType()
	// CreateBuilder creates a BACnetConstructedDataUserTypeBuilder
	CreateBACnetConstructedDataUserTypeBuilder() BACnetConstructedDataUserTypeBuilder
}

// _BACnetConstructedDataUserType is the data-structure of this message
type _BACnetConstructedDataUserType struct {
	BACnetConstructedDataContract
	UserType BACnetAccessUserTypeTagged
}

var _ BACnetConstructedDataUserType = (*_BACnetConstructedDataUserType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataUserType)(nil)

// NewBACnetConstructedDataUserType factory function for _BACnetConstructedDataUserType
func NewBACnetConstructedDataUserType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, userType BACnetAccessUserTypeTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataUserType {
	if userType == nil {
		panic("userType of type BACnetAccessUserTypeTagged for BACnetConstructedDataUserType must not be nil")
	}
	_result := &_BACnetConstructedDataUserType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		UserType:                      userType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataUserTypeBuilder is a builder for BACnetConstructedDataUserType
type BACnetConstructedDataUserTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(userType BACnetAccessUserTypeTagged) BACnetConstructedDataUserTypeBuilder
	// WithUserType adds UserType (property field)
	WithUserType(BACnetAccessUserTypeTagged) BACnetConstructedDataUserTypeBuilder
	// WithUserTypeBuilder adds UserType (property field) which is build by the builder
	WithUserTypeBuilder(func(BACnetAccessUserTypeTaggedBuilder) BACnetAccessUserTypeTaggedBuilder) BACnetConstructedDataUserTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataUserType or returns an error if something is wrong
	Build() (BACnetConstructedDataUserType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataUserType
}

// NewBACnetConstructedDataUserTypeBuilder() creates a BACnetConstructedDataUserTypeBuilder
func NewBACnetConstructedDataUserTypeBuilder() BACnetConstructedDataUserTypeBuilder {
	return &_BACnetConstructedDataUserTypeBuilder{_BACnetConstructedDataUserType: new(_BACnetConstructedDataUserType)}
}

type _BACnetConstructedDataUserTypeBuilder struct {
	*_BACnetConstructedDataUserType

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataUserTypeBuilder) = (*_BACnetConstructedDataUserTypeBuilder)(nil)

func (b *_BACnetConstructedDataUserTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataUserType
}

func (b *_BACnetConstructedDataUserTypeBuilder) WithMandatoryFields(userType BACnetAccessUserTypeTagged) BACnetConstructedDataUserTypeBuilder {
	return b.WithUserType(userType)
}

func (b *_BACnetConstructedDataUserTypeBuilder) WithUserType(userType BACnetAccessUserTypeTagged) BACnetConstructedDataUserTypeBuilder {
	b.UserType = userType
	return b
}

func (b *_BACnetConstructedDataUserTypeBuilder) WithUserTypeBuilder(builderSupplier func(BACnetAccessUserTypeTaggedBuilder) BACnetAccessUserTypeTaggedBuilder) BACnetConstructedDataUserTypeBuilder {
	builder := builderSupplier(b.UserType.CreateBACnetAccessUserTypeTaggedBuilder())
	var err error
	b.UserType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAccessUserTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataUserTypeBuilder) Build() (BACnetConstructedDataUserType, error) {
	if b.UserType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'userType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataUserType.deepCopy(), nil
}

func (b *_BACnetConstructedDataUserTypeBuilder) MustBuild() BACnetConstructedDataUserType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataUserTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataUserTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataUserTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataUserTypeBuilder().(*_BACnetConstructedDataUserTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataUserTypeBuilder creates a BACnetConstructedDataUserTypeBuilder
func (b *_BACnetConstructedDataUserType) CreateBACnetConstructedDataUserTypeBuilder() BACnetConstructedDataUserTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataUserTypeBuilder()
	}
	return &_BACnetConstructedDataUserTypeBuilder{_BACnetConstructedDataUserType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataUserType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataUserType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_USER_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataUserType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataUserType) GetUserType() BACnetAccessUserTypeTagged {
	return m.UserType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataUserType) GetActualValue() BACnetAccessUserTypeTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetAccessUserTypeTagged(m.GetUserType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataUserType(structType any) BACnetConstructedDataUserType {
	if casted, ok := structType.(BACnetConstructedDataUserType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataUserType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataUserType) GetTypeName() string {
	return "BACnetConstructedDataUserType"
}

func (m *_BACnetConstructedDataUserType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (userType)
	lengthInBits += m.UserType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataUserType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataUserType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataUserType BACnetConstructedDataUserType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataUserType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataUserType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	userType, err := ReadSimpleField[BACnetAccessUserTypeTagged](ctx, "userType", ReadComplex[BACnetAccessUserTypeTagged](BACnetAccessUserTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userType' field"))
	}
	m.UserType = userType

	actualValue, err := ReadVirtualField[BACnetAccessUserTypeTagged](ctx, "actualValue", (*BACnetAccessUserTypeTagged)(nil), userType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataUserType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataUserType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataUserType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataUserType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataUserType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataUserType")
		}

		if err := WriteSimpleField[BACnetAccessUserTypeTagged](ctx, "userType", m.GetUserType(), WriteComplex[BACnetAccessUserTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'userType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataUserType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataUserType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataUserType) IsBACnetConstructedDataUserType() {}

func (m *_BACnetConstructedDataUserType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataUserType) deepCopy() *_BACnetConstructedDataUserType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataUserTypeCopy := &_BACnetConstructedDataUserType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetAccessUserTypeTagged](m.UserType),
	}
	_BACnetConstructedDataUserTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataUserTypeCopy
}

func (m *_BACnetConstructedDataUserType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
