/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ProfinetDataType {
  BOOL((short) 1, (short) 1, (String) "BOOLEAN"),
  BYTE((short) 2, (short) 1, (String) "BYTE"),
  WORD((short) 3, (short) 2, (String) "WORD"),
  DWORD((short) 4, (short) 4, (String) "DWORD"),
  LWORD((short) 5, (short) 8, (String) "LWORD"),
  SINT((short) 6, (short) 1, (String) "SIGNED8"),
  INT((short) 7, (short) 2, (String) "SIGNED16"),
  DINT((short) 8, (short) 4, (String) "SIGNED32"),
  LINT((short) 9, (short) 8, (String) "SIGNED64"),
  USINT((short) 10, (short) 1, (String) "UNSIGNED8"),
  UINT((short) 11, (short) 2, (String) "UNSIGNED16"),
  UDINT((short) 12, (short) 4, (String) "UNSIGNED32"),
  ULINT((short) 13, (short) 8, (String) "UNSIGNED64"),
  REAL((short) 14, (short) 4, (String) "FLOAT32"),
  LREAL((short) 15, (short) 8, (String) "FLOAT64"),
  TIME((short) 16, (short) 8, (String) "TIME"),
  LTIME((short) 17, (short) 8, (String) "LTIME"),
  DATE((short) 18, (short) 8, (String) "DATE"),
  LDATE((short) 19, (short) 8, (String) "LDATE"),
  TIME_OF_DAY((short) 20, (short) 8, (String) "TIME_OF_DAY"),
  LTIME_OF_DAY((short) 21, (short) 8, (String) "LTIME_OF_DAY"),
  DATE_AND_TIME((short) 22, (short) 8, (String) "DATE_AND_TIME"),
  LDATE_AND_TIME((short) 23, (short) 8, (String) "LDATE_AND_TIME"),
  CHAR((short) 24, (short) 1, (String) "CHAR"),
  WCHAR((short) 25, (short) 2, (String) "WCHAR"),
  UNICODESTRING8((short) 26, (short) 1, (String) "UNICODESTRING8"),
  WSTRING((short) 27, (short) 2, (String) "WSTRING"),
  VISIBLESTRING((short) 28, (short) 1, (String) "VISIBLESTRING"),
  F_MESSAGETRAILER4BYTE((short) 29, (short) 4, (String) "F_MESSAGETRAILER4BYTE"),
  TIMESTAMP((short) 30, (short) 12, (String) "TIMESTAMP"),
  TIMESTAMPDIFFERENCE((short) 31, (short) 12, (String) "TIMESTAMPDIFFERENCE"),
  TIMESTAMPDIFFERENCESHORT((short) 32, (short) 8, (String) "TIMESTAMPDIFFERENCESHORT"),
  OCTETSTRING((short) 33, (short) 1, (String) "OCTETSTRING");
  private static final Map<Short, ProfinetDataType> map;

  static {
    map = new HashMap<>();
    for (ProfinetDataType value : ProfinetDataType.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final short dataTypeSize;
  private final String conversion;

  ProfinetDataType(short value, short dataTypeSize, String conversion) {
    this.value = value;
    this.dataTypeSize = dataTypeSize;
    this.conversion = conversion;
  }

  public short getValue() {
    return value;
  }

  public short getDataTypeSize() {
    return dataTypeSize;
  }

  public static ProfinetDataType firstEnumForFieldDataTypeSize(short fieldValue) {
    for (ProfinetDataType _val : ProfinetDataType.values()) {
      if (_val.getDataTypeSize() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<ProfinetDataType> enumsForFieldDataTypeSize(short fieldValue) {
    List<ProfinetDataType> _values = new ArrayList<>();
    for (ProfinetDataType _val : ProfinetDataType.values()) {
      if (_val.getDataTypeSize() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getConversion() {
    return conversion;
  }

  public static ProfinetDataType firstEnumForFieldConversion(String fieldValue) {
    for (ProfinetDataType _val : ProfinetDataType.values()) {
      if (_val.getConversion().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<ProfinetDataType> enumsForFieldConversion(String fieldValue) {
    List<ProfinetDataType> _values = new ArrayList<>();
    for (ProfinetDataType _val : ProfinetDataType.values()) {
      if (_val.getConversion().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static ProfinetDataType enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
