/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ParsingResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 612;
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final List<StatusCode> dataStatusCodes;
  protected final List<DiagnosticInfo> dataDiagnosticInfos;

  public ParsingResult(
      StatusCode statusCode,
      List<StatusCode> dataStatusCodes,
      List<DiagnosticInfo> dataDiagnosticInfos) {
    super();
    this.statusCode = statusCode;
    this.dataStatusCodes = dataStatusCodes;
    this.dataDiagnosticInfos = dataDiagnosticInfos;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public List<StatusCode> getDataStatusCodes() {
    return dataStatusCodes;
  }

  public List<DiagnosticInfo> getDataDiagnosticInfos() {
    return dataDiagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ParsingResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, writeComplex(writeBuffer));

    // Implicit Field (noOfDataStatusCodes) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataStatusCodes =
        (int) ((((getDataStatusCodes()) == (null)) ? -(1) : COUNT(getDataStatusCodes())));
    writeImplicitField("noOfDataStatusCodes", noOfDataStatusCodes, writeSignedInt(writeBuffer, 32));

    // Array Field (dataStatusCodes)
    writeComplexTypeArrayField("dataStatusCodes", dataStatusCodes, writeBuffer);

    // Implicit Field (noOfDataDiagnosticInfos) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfDataDiagnosticInfos =
        (int) ((((getDataDiagnosticInfos()) == (null)) ? -(1) : COUNT(getDataDiagnosticInfos())));
    writeImplicitField(
        "noOfDataDiagnosticInfos", noOfDataDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (dataDiagnosticInfos)
    writeComplexTypeArrayField("dataDiagnosticInfos", dataDiagnosticInfos, writeBuffer);

    writeBuffer.popContext("ParsingResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ParsingResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Implicit Field (noOfDataStatusCodes)
    lengthInBits += 32;

    // Array field
    if (dataStatusCodes != null) {
      int i = 0;
      for (StatusCode element : dataStatusCodes) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataStatusCodes.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDataDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (dataDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : dataDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ParsingResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    StatusCode statusCode =
        readSimpleField(
            "statusCode", readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer));

    int noOfDataStatusCodes =
        readImplicitField("noOfDataStatusCodes", readSignedInt(readBuffer, 32));

    List<StatusCode> dataStatusCodes =
        readCountArrayField(
            "dataStatusCodes",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfDataStatusCodes);

    int noOfDataDiagnosticInfos =
        readImplicitField("noOfDataDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> dataDiagnosticInfos =
        readCountArrayField(
            "dataDiagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDataDiagnosticInfos);

    readBuffer.closeContext("ParsingResult");
    // Create the instance
    return new ParsingResultBuilderImpl(statusCode, dataStatusCodes, dataDiagnosticInfos);
  }

  public static class ParsingResultBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final List<StatusCode> dataStatusCodes;
    private final List<DiagnosticInfo> dataDiagnosticInfos;

    public ParsingResultBuilderImpl(
        StatusCode statusCode,
        List<StatusCode> dataStatusCodes,
        List<DiagnosticInfo> dataDiagnosticInfos) {
      this.statusCode = statusCode;
      this.dataStatusCodes = dataStatusCodes;
      this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    public ParsingResult build() {
      ParsingResult parsingResult =
          new ParsingResult(statusCode, dataStatusCodes, dataDiagnosticInfos);
      return parsingResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ParsingResult)) {
      return false;
    }
    ParsingResult that = (ParsingResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getDataStatusCodes() == that.getDataStatusCodes())
        && (getDataDiagnosticInfos() == that.getDataDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getStatusCode(), getDataStatusCodes(), getDataDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
