/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataMainsFailure is the corresponding interface of SecurityDataMainsFailure
type SecurityDataMainsFailure interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataMainsFailure is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataMainsFailure()
	// CreateBuilder creates a SecurityDataMainsFailureBuilder
	CreateSecurityDataMainsFailureBuilder() SecurityDataMainsFailureBuilder
}

// _SecurityDataMainsFailure is the data-structure of this message
type _SecurityDataMainsFailure struct {
	SecurityDataContract
}

var _ SecurityDataMainsFailure = (*_SecurityDataMainsFailure)(nil)
var _ SecurityDataRequirements = (*_SecurityDataMainsFailure)(nil)

// NewSecurityDataMainsFailure factory function for _SecurityDataMainsFailure
func NewSecurityDataMainsFailure(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataMainsFailure {
	_result := &_SecurityDataMainsFailure{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataMainsFailureBuilder is a builder for SecurityDataMainsFailure
type SecurityDataMainsFailureBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataMainsFailureBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataMainsFailure or returns an error if something is wrong
	Build() (SecurityDataMainsFailure, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataMainsFailure
}

// NewSecurityDataMainsFailureBuilder() creates a SecurityDataMainsFailureBuilder
func NewSecurityDataMainsFailureBuilder() SecurityDataMainsFailureBuilder {
	return &_SecurityDataMainsFailureBuilder{_SecurityDataMainsFailure: new(_SecurityDataMainsFailure)}
}

type _SecurityDataMainsFailureBuilder struct {
	*_SecurityDataMainsFailure

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataMainsFailureBuilder) = (*_SecurityDataMainsFailureBuilder)(nil)

func (b *_SecurityDataMainsFailureBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataMainsFailure
}

func (b *_SecurityDataMainsFailureBuilder) WithMandatoryFields() SecurityDataMainsFailureBuilder {
	return b
}

func (b *_SecurityDataMainsFailureBuilder) Build() (SecurityDataMainsFailure, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataMainsFailure.deepCopy(), nil
}

func (b *_SecurityDataMainsFailureBuilder) MustBuild() SecurityDataMainsFailure {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataMainsFailureBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataMainsFailureBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataMainsFailureBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataMainsFailureBuilder().(*_SecurityDataMainsFailureBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataMainsFailureBuilder creates a SecurityDataMainsFailureBuilder
func (b *_SecurityDataMainsFailure) CreateSecurityDataMainsFailureBuilder() SecurityDataMainsFailureBuilder {
	if b == nil {
		return NewSecurityDataMainsFailureBuilder()
	}
	return &_SecurityDataMainsFailureBuilder{_SecurityDataMainsFailure: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataMainsFailure) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataMainsFailure(structType any) SecurityDataMainsFailure {
	if casted, ok := structType.(SecurityDataMainsFailure); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataMainsFailure); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataMainsFailure) GetTypeName() string {
	return "SecurityDataMainsFailure"
}

func (m *_SecurityDataMainsFailure) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataMainsFailure) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataMainsFailure) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataMainsFailure SecurityDataMainsFailure, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataMainsFailure"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataMainsFailure")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataMainsFailure"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataMainsFailure")
	}

	return m, nil
}

func (m *_SecurityDataMainsFailure) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataMainsFailure) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataMainsFailure"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataMainsFailure")
		}

		if popErr := writeBuffer.PopContext("SecurityDataMainsFailure"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataMainsFailure")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataMainsFailure) IsSecurityDataMainsFailure() {}

func (m *_SecurityDataMainsFailure) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataMainsFailure) deepCopy() *_SecurityDataMainsFailure {
	if m == nil {
		return nil
	}
	_SecurityDataMainsFailureCopy := &_SecurityDataMainsFailure{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataMainsFailureCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataMainsFailureCopy
}

func (m *_SecurityDataMainsFailure) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
