/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// XVType is the corresponding interface of XVType
type XVType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetX returns X (property field)
	GetX() float64
	// GetValue returns Value (property field)
	GetValue() float32
	// IsXVType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsXVType()
	// CreateBuilder creates a XVTypeBuilder
	CreateXVTypeBuilder() XVTypeBuilder
}

// _XVType is the data-structure of this message
type _XVType struct {
	ExtensionObjectDefinitionContract
	X     float64
	Value float32
}

var _ XVType = (*_XVType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_XVType)(nil)

// NewXVType factory function for _XVType
func NewXVType(x float64, value float32) *_XVType {
	_result := &_XVType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		X:                                 x,
		Value:                             value,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// XVTypeBuilder is a builder for XVType
type XVTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(x float64, value float32) XVTypeBuilder
	// WithX adds X (property field)
	WithX(float64) XVTypeBuilder
	// WithValue adds Value (property field)
	WithValue(float32) XVTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the XVType or returns an error if something is wrong
	Build() (XVType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() XVType
}

// NewXVTypeBuilder() creates a XVTypeBuilder
func NewXVTypeBuilder() XVTypeBuilder {
	return &_XVTypeBuilder{_XVType: new(_XVType)}
}

type _XVTypeBuilder struct {
	*_XVType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (XVTypeBuilder) = (*_XVTypeBuilder)(nil)

func (b *_XVTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._XVType
}

func (b *_XVTypeBuilder) WithMandatoryFields(x float64, value float32) XVTypeBuilder {
	return b.WithX(x).WithValue(value)
}

func (b *_XVTypeBuilder) WithX(x float64) XVTypeBuilder {
	b.X = x
	return b
}

func (b *_XVTypeBuilder) WithValue(value float32) XVTypeBuilder {
	b.Value = value
	return b
}

func (b *_XVTypeBuilder) Build() (XVType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._XVType.deepCopy(), nil
}

func (b *_XVTypeBuilder) MustBuild() XVType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_XVTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_XVTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_XVTypeBuilder) DeepCopy() any {
	_copy := b.CreateXVTypeBuilder().(*_XVTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateXVTypeBuilder creates a XVTypeBuilder
func (b *_XVType) CreateXVTypeBuilder() XVTypeBuilder {
	if b == nil {
		return NewXVTypeBuilder()
	}
	return &_XVTypeBuilder{_XVType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_XVType) GetExtensionId() int32 {
	return int32(12082)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_XVType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_XVType) GetX() float64 {
	return m.X
}

func (m *_XVType) GetValue() float32 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastXVType(structType any) XVType {
	if casted, ok := structType.(XVType); ok {
		return casted
	}
	if casted, ok := structType.(*XVType); ok {
		return *casted
	}
	return nil
}

func (m *_XVType) GetTypeName() string {
	return "XVType"
}

func (m *_XVType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (x)
	lengthInBits += 64

	// Simple field (value)
	lengthInBits += 32

	return lengthInBits
}

func (m *_XVType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_XVType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__xVType XVType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("XVType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for XVType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	x, err := ReadSimpleField(ctx, "x", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'x' field"))
	}
	m.X = x

	value, err := ReadSimpleField(ctx, "value", ReadFloat(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("XVType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for XVType")
	}

	return m, nil
}

func (m *_XVType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_XVType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("XVType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for XVType")
		}

		if err := WriteSimpleField[float64](ctx, "x", m.GetX(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'x' field")
		}

		if err := WriteSimpleField[float32](ctx, "value", m.GetValue(), WriteFloat(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("XVType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for XVType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_XVType) IsXVType() {}

func (m *_XVType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_XVType) deepCopy() *_XVType {
	if m == nil {
		return nil
	}
	_XVTypeCopy := &_XVType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.X,
		m.Value,
	}
	_XVTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _XVTypeCopy
}

func (m *_XVType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
