/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.lib.graph.Edge;
import org.apache.openjpa.lib.graph.Graph;
import org.apache.openjpa.lib.graph.GraphVisitor;
import org.apache.openjpa.lib.graph.NodeInfo;

public class BreadthFirstWalk {
    private final Graph _graph;
    private final Set<GraphVisitor> _visitors = new HashSet<GraphVisitor>();
    private final List<Object> _queue = new LinkedList<Object>();
    private final Map<Object, NodeInfo> _nodeInfo = new HashMap<Object, NodeInfo>();

    public BreadthFirstWalk(Graph graph) {
        this._graph = graph;
    }

    public void walk() {
        this._queue.clear();
        this._nodeInfo.clear();
        Collection<Object> nodes = this._graph.getNodes();
        for (Object node : nodes) {
            this._nodeInfo.put(node, new NodeInfo());
        }
        for (Object node : nodes) {
            NodeInfo info = this._nodeInfo.get(node);
            if (info.color == 0) {
                this.enqueue(node, info);
            }
            this.processQueue();
        }
    }

    private void processQueue() {
        while (this._queue.size() > 0) {
            Object node = this._queue.remove(0);
            NodeInfo info = this._nodeInfo.get(node);
            this.visit(node, info);
            Collection<Edge> edges = this._graph.getEdgesFrom(node);
            for (Edge edge : edges) {
                this.edgeVisited(edge);
                Object other = edge.getOther(node);
                NodeInfo otherInfo = this._nodeInfo.get(other);
                if (otherInfo.color != 0) continue;
                this.enqueue(other, otherInfo);
            }
        }
    }

    protected void enqueue(Object node, NodeInfo info) {
        this._queue.add(node);
        info.color = 1;
        for (GraphVisitor visitor : this._visitors) {
            visitor.nodeSeen(node);
        }
    }

    protected void visit(Object node, NodeInfo info) {
        info.color = 2;
        for (GraphVisitor visitor : this._visitors) {
            visitor.nodeVisited(node);
        }
    }

    protected void edgeVisited(Edge edge) {
        for (GraphVisitor visitor : this._visitors) {
            visitor.edgeVisited(edge);
        }
    }

    public void addGraphVisitor(GraphVisitor visitor) {
        this._visitors.add(visitor);
    }

    public void removeGraphVisitor(GraphVisitor visitor) {
        this._visitors.remove(visitor);
    }
}

