/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;

public class ExpandTreeBuilderImpl
extends ExpandTreeBuilder {
    private final Map<String, ExpandTreeBuilder> childBuilderCache = new HashMap<String, ExpandTreeBuilder>();
    private final ExpandItemImpl parentItem;
    private ExpandOptionImpl expandOption = null;

    private ExpandTreeBuilderImpl(ExpandItemImpl parentItem) {
        this.parentItem = parentItem;
    }

    @Override
    public ExpandTreeBuilder expand(EdmNavigationProperty edmNavigationProperty) {
        ExpandTreeBuilder builder;
        if (this.expandOption == null) {
            this.expandOption = new ExpandOptionImpl();
            if (this.parentItem != null && this.parentItem.getExpandOption() == null) {
                this.parentItem.setSystemQueryOption(this.expandOption);
            }
        }
        if ((builder = this.childBuilderCache.get(edmNavigationProperty.getName())) == null) {
            ExpandItemImpl expandItem = this.buildExpandItem(edmNavigationProperty);
            this.expandOption.addExpandItem(expandItem);
            builder = new ExpandTreeBuilderImpl(expandItem);
            this.childBuilderCache.put(edmNavigationProperty.getName(), builder);
        }
        return builder;
    }

    @Override
    public ExpandOption build() {
        return this.expandOption;
    }

    public static ExpandTreeBuilder create() {
        return new ExpandTreeBuilderImpl(null);
    }
}

