/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import java.util.Collection;
import java.util.HashMap;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ManualArrayCopy {
    public static ErrorDescription arrayCopy(final HintContext ctx) {
        String length;
        String startTarget;
        String startSource;
        TypeMirror sourceType = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$arr"));
        TypeMirror targetType = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$tarr"));
        if (!(Utilities.isValidType(sourceType) && Utilities.isValidType(targetType) && ctx.getInfo().getTypes().isSubtype(sourceType, targetType))) {
            return null;
        }
        boolean isSZero = MatcherUtilities.matches(ctx, ctx.getVariables().get("$s"), "0");
        HashMap<String, TreePath> innerVariables = new HashMap<String, TreePath>();
        TreePath base = ctx.getVariables().get("$arr");
        final Element i = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$i"));
        if (i != null) {
            final boolean[] used = new boolean[1];
            new ErrorAwareTreePathScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element use = ctx.getInfo().getTrees().getElement(this.getCurrentPath());
                    if (i.equals(use)) {
                        used[0] = used[0] | true;
                    }
                    return (Void)super.visitIdentifier(node, p);
                }
            }.scan(base, (Void)null);
            if (used[0]) {
                return null;
            }
        }
        while (MatcherUtilities.matches(ctx, base, "$oarr[$innerIndex]", innerVariables, new HashMap<String, Collection<? extends TreePath>>(), new HashMap<String, String>())) {
            base = (TreePath)innerVariables.get("$oarr");
        }
        if (ctx.getVariables().containsKey("$o1")) {
            if (isSZero) {
                startSource = "0";
                startTarget = "$o1";
                length = "$len";
            } else {
                startSource = "$s";
                startTarget = "$o1 + $s";
                length = "$len - $s";
            }
        } else if (ctx.getVariables().containsKey("$o2")) {
            if (isSZero) {
                startSource = "0";
                startTarget = "$o2";
                length = "$len";
            } else {
                startSource = "$s";
                startTarget = "$s + $o2";
                length = "$len - $s";
            }
        } else if (isSZero) {
            startSource = "0";
            startTarget = "0";
            length = "$len";
        } else {
            startSource = "$s";
            startTarget = "$s";
            length = "$len - $s";
        }
        String fix = String.format("java.lang.System.arraycopy($arr, %s, $tarr, %s, %s);", startSource, startTarget, length);
        return ManualArrayCopy.compute(ctx, "manual-array-copy", fix);
    }

    public static ErrorDescription collection(HintContext ctx) {
        return ManualArrayCopy.compute(ctx, "manual-array-copy-coll", "$coll.addAll(java.util.Arrays.asList($arr));");
    }

    private static ErrorDescription compute(HintContext ctx, String key, String to) {
        String fixDisplayName = NbBundle.getMessage(ManualArrayCopy.class, "FIX_" + key);
        Fix fix = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), to);
        String displayName = NbBundle.getMessage(ManualArrayCopy.class, "ERR_" + key);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fix);
    }
}

