/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

public class LocallyDownloadedTableModel
extends UnitCategoryTableModel {
    private OperationContainer<InstallSupport> availableNbmsContainer = Containers.forAvailableNbms();
    private OperationContainer<InstallSupport> updateNbmsContainer = Containers.forUpdateNbms();
    private LocalDownloadSupport localDownloadSupport = null;
    List<UpdateUnit> cachedUnits;

    public LocallyDownloadedTableModel(LocalDownloadSupport localDownloadSupport) {
        this.localDownloadSupport = localDownloadSupport;
    }

    @Override
    public final void setUnits(List<UpdateUnit> unused) {
        this.getLocalDownloadSupport().removeInstalledUnit();
        Collection<UpdateUnit> units = this.getLocalDownloadSupport().getUpdateUnits();
        if (this.cachedUnits == null || !units.containsAll(this.cachedUnits) || !this.cachedUnits.containsAll(units)) {
            this.setData(this.makeCategories(new LinkedList<UpdateUnit>(units)));
            this.cachedUnits = new ArrayList<UpdateUnit>(units);
        }
    }

    void removeInstalledUnits() {
        this.getLocalDownloadSupport().removeInstalledUnit();
        this.cachedUnits = null;
        this.setUnits(null);
    }

    private List<UnitCategory> makeCategories(List<UpdateUnit> units) {
        ArrayList<UnitCategory> categories = new ArrayList<UnitCategory>();
        categories.addAll(Utilities.makeAvailableCategories(units, true));
        categories.addAll(Utilities.makeUpdateCategories(units, true));
        return categories;
    }

    LocalDownloadSupport getLocalDownloadSupport() {
        return this.localDownloadSupport;
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        super.setValueAt(anValue, row, col);
        if (anValue == null) {
            return;
        }
        if (!(anValue instanceof Boolean)) {
            return;
        }
        Unit u = this.getUnitAtRow(row);
        if (u != null) {
            assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
            boolean beforeMarked = u.isMarked();
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
                if (u.isMarked()) {
                    this.getLocalDownloadSupport().checkUnit(u.updateUnit);
                } else {
                    this.getLocalDownloadSupport().uncheckUnit(u.updateUnit);
                }
            } else assert (false) : u.getDisplayName();
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        Unit u = this.getUnitAtRow(row);
        if (u != null) {
            boolean isAvailable = u instanceof Unit.Available;
            switch (col) {
                case 0: {
                    res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    res = u.getDisplayName();
                    break;
                }
                case 2: {
                    res = u.getCategoryName();
                    break;
                }
                case 3: {
                    if (isAvailable) {
                        res = ((Unit.Available)u).getAvailableVersion();
                        break;
                    }
                    res = ((Unit.Update)u).getAvailableVersion();
                    break;
                }
                case 4: {
                    res = isAvailable ? ((Unit.Available)u).getSize() : ((Unit.Update)u).getSize();
                }
            }
        }
        return res;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = String.class;
                break;
            }
            case 4: {
                res = String.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Install");
            }
            case 1: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Name");
            }
            case 2: {
                return this.getBundle("InstalledTableModel_Columns_Category");
            }
            case 3: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Version");
            }
            case 4: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Size");
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public int getPreferredWidth(JTableHeader header, int col) {
        switch (col) {
            case 1: {
                return super.getMinWidth(header, col) * 4;
            }
            case 2: {
                return super.getMinWidth(header, col) * 2;
            }
        }
        return super.getMinWidth(header, col);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.LOCAL;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isInstall = this.getColumnName(0).equals(columnIdentifier);
        boolean isSize = this.getColumnName(4).equals(columnIdentifier);
        return !isInstall && !isSize;
    }

    @Override
    protected Comparator<Unit> getDefaultComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return Unit.compareDisplayNames(o1, o2);
            }
        };
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (LocallyDownloadedTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (LocallyDownloadedTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.compareCategories(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(3).equals(columnIdentifier)) {
                        return Unit.compareDisplayVersions(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(4).equals(columnIdentifier)) assert (false) : columnIdentifier.toString();
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        return 0;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(this.getClass(), key);
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, "PluginManagerUI_UnitTab_Local_Title");
    }

    @Override
    public int getTabIndex() {
        return 2;
    }

    @Override
    public boolean canBePrimaryTab() {
        return false;
    }

    @Override
    public boolean needsRestart() {
        return false;
    }

    public class DisplayName {
        public DisplayName(String name) {
        }
    }
}

