/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nbjavac.ModuleWrapper;

public class ServiceLoaderWrapper<T>
implements Iterable<T> {
    private final ServiceLoader<T> loader;

    public ServiceLoaderWrapper(ServiceLoader<T> loader) {
        this.loader = loader;
    }

    public static <T> ServiceLoader<T> load(ModuleWrapper.ModuleLayer layer, Class<T> aClass) {
        ModuleWrapper.ensureUses(aClass);
        return ServiceLoader.load(aClass);
    }

    public static <T> ServiceLoaderWrapper<T> load(Class<T> aClass) {
        ModuleWrapper.ensureUses(aClass);
        return new ServiceLoaderWrapper<T>(ServiceLoader.load(aClass));
    }

    public static <T> ServiceLoaderWrapper<T> load(Class<T> aClass, ClassLoader classLoader) {
        ModuleWrapper.ensureUses(aClass);
        return new ServiceLoaderWrapper<T>(ServiceLoader.load(aClass, classLoader));
    }

    public static <T> ServiceLoader<T> loadWithClassLoader(Class<T> aClass, ClassLoader classLoader) {
        ModuleWrapper.ensureUses(aClass);
        return ServiceLoader.load(aClass, classLoader);
    }

    public Stream<Provider<T>> stream() {
        return StreamSupport.stream(this.loader.spliterator(), false).map(v -> new Provider<T>(){

            @Override
            public Class<? extends T> type() {
                return v.getClass();
            }

            @Override
            public T get() {
                return v;
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.loader.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.loader.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.loader.spliterator();
    }

    public static interface Provider<T> {
        public Class<? extends T> type();

        public T get();
    }
}

