/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.blank;

import org.apache.myfaces.blank.domain.Person;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;

/**
 * A typical simple backing bean, that is backed to <code>helloworld.jsp</code>
 */
@ManagedBean(name = "helloWorld")
@RequestScoped
public class HelloWorldController
{
    private Person person = new Person();

    /**
     * default empty constructor
     */
    public HelloWorldController()
    {
    }

    public String send()
    {
        //do real logic, return a string which will be used for the navigation system of JSF
        return "success";
    }

    public Person getPerson()
    {
        return person;
    }

    public void setPerson(Person person)
    {
        this.person = person;
    }
}