/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

import org.apache.commons.validator.GenericValidator;
import org.apache.myfaces.buildtools.maven2.plugin.builder.annotation.JSFProperty;
import org.apache.myfaces.buildtools.maven2.plugin.builder.annotation.JSFValidator;

/**
 * A custom validator for reg. expr., based upons Jakarta Commons. 
 * 
 * Unless otherwise specified, all attributes accept static values or EL expressions.
 * 
 * 
 * @author mwessendorf (latest modification by $Author: struberg $)
 * @version $Revision: 1186881 $ $Date: 2011-10-20 11:13:22 -0500 (Thu, 20 Oct 2011) $
 */
@JSFValidator(
   name = "mcv:validateRegExpr",
   clazz = "org.apache.myfaces.commons.validator.RegExprValidator",
   tagClass = "org.apache.myfaces.commons.validator.ValidateRegExprTag",
   serialuidtag = "-449945949876262076L")
public abstract class AbstractRegExprValidator extends ValidatorBase
{
    /**
     * <p>The standard converter id for this converter.</p>
     */
    public static final String     VALIDATOR_ID        = "org.apache.myfaces.commons.validator.RegExpr";

    /**
     * <p>The message identifier of the {@link javax.faces.application.FacesMessage} to be created if
     * the regex check fails.</p>
     */
    public static final String REGEXPR_MESSAGE_ID = "org.apache.myfaces.commons.validator.RegExpr.INVALID";

    public AbstractRegExprValidator()
    {
    }

    public void validate(
        FacesContext facesContext,
        UIComponent uiComponent,
        Object value)
        throws ValidatorException
    {

        if (facesContext == null)
        {
            throw new NullPointerException("facesContext");
        }

        if (uiComponent == null)
        {
            throw new NullPointerException("uiComponent");
        }

        if (value == null)
        {
            return;
        }

        Object[] args = {value.toString()};
        String pattern = getPattern();
        if (pattern == null)
        {
            pattern = getPatternExpression();
        }
        else if (pattern != null && pattern.length() <= 0)
        {
            pattern = getPatternExpression();
        }
        if(!GenericValidator.matchRegexp(value.toString(),"^"+pattern+"$"))
        {
            throw new ValidatorException(getFacesMessage(REGEXPR_MESSAGE_ID, args));
        }
    }

    // -------------------------------------------------------- GETTER & SETTER

    /**
     * the pattern, which is the base of the validation. It does
     * not allow EL expressions (jsp special case).
     * 
     * @return the pattern, on which a value should be validated
     */
    @JSFProperty(
       literalOnly = true)
    public abstract String getPattern();

    /**
     * @param string the pattern, on which a value should be validated
     */
    public abstract void setPattern(String string);

    /**
     * the pattern, which is the base of the validation. It 
     * allow EL expressions.
     * 
     * @return the pattern, on which a value should be validated
     */
    @JSFProperty
    public abstract String getPatternExpression();
    
    
}
