/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.component.search.UntargetableComponent;
import java.util.List;

public class PreviousSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String PREVIOUS_KEYWORD = "previous";

    @Override
    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        List<UIComponent> children;
        int index;
        UIComponent parent = current.getParent();
        if (parent.getChildCount() > 1 && (index = (children = parent.getChildren()).indexOf(current)) > 0) {
            int nextIndex = -1;
            do {
                if (children.get(--index) instanceof UntargetableComponent) continue;
                nextIndex = index;
            } while (nextIndex == -1 && index > 0);
            if (nextIndex != -1) {
                expressionContext.invokeContextCallback(children.get(nextIndex));
            }
        }
        expressionContext.setKeywordResolved(true);
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return PREVIOUS_KEYWORD.equalsIgnoreCase(keyword);
    }

    @Override
    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    @Override
    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

