/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeParser;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalkerBase;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;

public abstract class QueryUtilBase<T extends TreeParser> {
    protected T walker = null;
    protected QueryObject queryObj;
    protected PredicateWalkerBase predicateWalker;
    protected String statement;
    protected CommonTree parserTree;
    protected TokenStream tokens;

    public abstract CommonTree parseStatement() throws RecognitionException;

    public abstract void walkStatement() throws RecognitionException;

    public void processStatement() throws RecognitionException {
        this.parseStatement();
        this.walkStatement();
    }

    protected QueryUtilBase(String statement, TypeManager tm, PredicateWalkerBase pw, QueryObject.ParserMode mode) {
        this.queryObj = new QueryObject(tm);
        if (mode != null) {
            this.queryObj.setSelectMode(mode);
        }
        this.predicateWalker = pw;
        this.statement = statement;
    }

    public T getWalker() {
        return this.walker;
    }

    public PredicateWalkerBase getPredicateWalker() {
        return this.predicateWalker;
    }

    public QueryObject getQueryObject() {
        return this.queryObj;
    }

    public String getStatement() {
        return this.statement;
    }

    public void processStatementUsingCmisExceptions() {
        try {
            this.processStatement();
        }
        catch (RecognitionException e) {
            String errorMsg = this.getErrorMessage(e);
            throw new CmisInvalidArgumentException("Processing of query statement failed with RecognitionException error: \n   " + errorMsg, (Throwable)e);
        }
        catch (CmisBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Processing of query statement failed with exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getErrorMessage(RecognitionException e) {
        if (null == this.walker) {
            return e.toString();
        }
        return QueryUtilBase.getErrorMessage(this.walker, e);
    }

    private static String getErrorMessage(BaseRecognizer recognizer, RecognitionException e) {
        String[] tokenNames = recognizer.getTokenNames();
        String hdr = "Line " + e.line + ":" + e.charPositionInLine;
        String msg = recognizer.getErrorMessage(e, tokenNames);
        return hdr + " " + msg;
    }
}

