/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.nio.Buffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.StringJoiner;
import java.util.function.IntSupplier;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.ConcatenatedVector;
import org.apache.sis.math.LinearlyDerivedVector;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.PackedVector;
import org.apache.sis.math.RepeatedVector;
import org.apache.sis.math.SequenceVector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class Vector
extends AbstractList<Number>
implements RandomAccess {
    static final int PRIME = 31;

    public static Vector create(Object object, boolean bl) throws IllegalArgumentException {
        Buffer buffer;
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return ArrayVector.newInstance(object, bl);
        }
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof Buffer && (buffer = (Buffer)object).hasArray()) {
            int n = buffer.arrayOffset();
            return ArrayVector.newInstance(buffer.array(), bl).subList(n + buffer.position(), n + buffer.limit());
        }
        throw new IllegalArgumentException(Errors.format((short)42, "array", object.getClass()));
    }

    public static Vector create(double[] dArray) {
        return dArray != null ? new ArrayVector.Doubles(dArray) : null;
    }

    public static Vector createForDecimal(float[] fArray) {
        return fArray != null ? new ArrayVector.Decimal(fArray) : null;
    }

    public static Vector createSequence(Number number, Number number2, int n) {
        Class<? extends Number> clazz = Numbers.widestClass(number, number2);
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass(number.doubleValue() + number2.doubleValue() * (double)(n - 1)));
        return Vector.createSequence(clazz, number, number2, n);
    }

    static Vector createSequence(Class<? extends Number> clazz, Number number, Number number2, int n) {
        byte by = Numbers.getEnumConstant(clazz);
        if (by >= 3 && by <= 6) {
            return new SequenceVector.Longs(clazz, number, number2, n);
        }
        if (by == 8) {
            return new SequenceVector.Floats(clazz, number, number2, n);
        }
        return new SequenceVector.Doubles(clazz, number, number2, n);
    }

    protected Vector() {
    }

    public abstract Class<? extends Number> getElementType();

    public boolean isSinglePrecision() {
        byte by = Numbers.getEnumConstant(this.getElementType());
        return by == 8 || by >= 3 && by <= 4;
    }

    private int getBitCount() {
        try {
            return Numbers.primitiveBitCount(this.getElementType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 32;
        }
    }

    public boolean isInteger() {
        if (!Numbers.isInteger(this.getElementType())) {
            int n = this.size();
            while (--n >= 0) {
                double d = this.doubleValue(n);
                if (d == Math.floor(d)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnsigned() {
        return false;
    }

    @Override
    public abstract int size();

    public boolean isEmptyOrNaN() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.isNaN(i)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isNaN(int var1);

    public abstract double doubleValue(int var1);

    public float floatValue(int n) {
        return (float)this.doubleValue(n);
    }

    public long longValue(int n) {
        double d = this.doubleValue(n);
        long l = Math.round(d);
        if (Math.abs((double)l - d) <= 0.5) {
            return l;
        }
        throw this.canNotConvert(n, Long.TYPE);
    }

    public int intValue(int n) {
        long l = this.longValue(n);
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        throw this.canNotConvert(n, Integer.TYPE);
    }

    public short shortValue(int n) {
        long l = this.longValue(n);
        if (l >= -32768L && l <= 32767L) {
            return (short)l;
        }
        throw this.canNotConvert(n, Short.TYPE);
    }

    public byte byteValue(int n) {
        long l = this.longValue(n);
        if (l >= -128L && l <= 127L) {
            return (byte)l;
        }
        throw this.canNotConvert(n, Byte.TYPE);
    }

    private ArithmeticException canNotConvert(int n, Class<?> clazz) {
        return new ArithmeticException(Errors.format((short)8, this.stringValue(n), clazz));
    }

    public abstract String stringValue(int var1);

    @Override
    public abstract Number get(int var1);

    @Override
    public abstract Number set(int var1, Number var2);

    public void fill(int n, int n2, Number number) {
        ArgumentChecks.ensureValidIndexRange(this.size(), n, n2);
        while (n < n2) {
            this.set(n++, number);
        }
    }

    int indexOf(int n, int n2, boolean bl) {
        Number number = this.get(n);
        int n3 = this.size();
        while (n2 < n3 && number.equals(this.get(n2)) != bl) {
            ++n2;
        }
        return n2;
    }

    public int[] repetitions(int ... nArray) {
        int n;
        if (nArray != null && nArray.length == 0) {
            nArray = null;
        }
        if ((n = this.size()) >= 2) {
            int n2;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n - 1; n3 += n4) {
                n2 = n4;
                n4 = this.indexOf(n3, n3 + 1, false) - n3;
                if (n4 > 1 && n2 % n4 == 0) continue;
                n4 = 1;
                break;
            }
            n3 = 0;
            n2 = n4 == 1 ? this.indexOf(0, 1, false) : 0;
            int n5 = 0;
            block1: while (true) {
                int n6;
                if (nArray != null) {
                    do {
                        if (n3 >= nArray.length) {
                            n5 = n;
                            break block1;
                        }
                        n6 = nArray[n3++];
                        ArgumentChecks.ensureStrictlyPositive("candidates", n6);
                    } while ((n5 = Math.multiplyExact(n4, n6)) <= 0 || n5 >= n);
                } else {
                    n5 += n4;
                    if (n2 != 0) {
                        n5 = this.indexOf(0, n5, true);
                        if (n2 != 1) {
                            if (n5 + n2 >= n) break;
                            n6 = this.indexOf(n5, n5 + 1, false);
                            if (n6 - n5 != n2) {
                                n5 = n6 - 1;
                                continue;
                            }
                        }
                    }
                    if (n5 >= n) break;
                }
                if (!this.equals(n2, Math.min(n4, n - n5), this, n5 + n2)) continue;
                for (n6 = n5; n6 < n; n6 += n5) {
                    if (this.equals(0, Math.min(n5, n - n6), this, n6)) continue;
                    continue block1;
                }
                break;
            }
            if (n5 < n) {
                return new int[]{n4, n5 / n4};
            }
            if (n4 != 1) {
                return new int[]{n4};
            }
        }
        return ArraysExt.EMPTY_INT;
    }

    final long subtract(long l, long l2) {
        long l3 = l - l2;
        if ((((long)(this.isUnsigned() ? Long.compareUnsigned(l, l2) : Long.compare(l, l2)) ^ l3) & Long.MIN_VALUE) != 0L) {
            throw new ArithmeticException(Errors.format((short)10, 64));
        }
        return l3;
    }

    public Number increment(double d) {
        ArgumentChecks.ensurePositive("tolerance", d);
        int n = this.size();
        if (n >= 2) {
            try {
                int n2;
                byte by = Numbers.getEnumConstant(this.getElementType());
                if (by >= 3 && by <= 6 && d < 0.5) {
                    long l = this.longValue(--n);
                    long l2 = this.longValue(--n);
                    long l3 = this.subtract(l, l2);
                    while (n != 0) {
                        if (l2 - (l2 = this.longValue(--n)) == l3) continue;
                        return null;
                    }
                    switch (by) {
                        case 3: {
                            if (l3 >= -128L && l3 <= 127L) {
                                return (byte)l3;
                            }
                        }
                        case 4: {
                            if (l3 >= -32768L && l3 <= 32767L) {
                                return (short)l3;
                            }
                        }
                        case 5: {
                            if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) break;
                            return (int)l3;
                        }
                    }
                    return l3;
                }
                double d2 = this.doubleValue(0);
                double d3 = (this.doubleValue(--n) - d2) / (double)n;
                if ((by == 9 || by == 11) && this.doubleValue(n2 = Math.max(0, Math.min(n, (int)Math.rint(-d2 / d3)))) == 0.0) {
                    Number number;
                    Number number2 = number = n2 == n ? (Number)this.get(n2 - 1) : (Number)this.get(n2 + 1);
                    if (number != null && !(number instanceof Float)) {
                        d3 = number.doubleValue();
                        if (n2 == n) {
                            d3 = -d3;
                        }
                    }
                }
                if (by == 8) {
                    while (n >= 1) {
                        float f = this.floatValue(n);
                        double d4 = Math.abs(d2 + d3 * (double)n-- - (double)f);
                        double d5 = Math.ulp(f);
                        if (!(d5 > d) ? d4 <= d : d4 < d5) continue;
                        return null;
                    }
                    float f = (float)d3;
                    if ((double)f == d3) {
                        return Float.valueOf(f);
                    }
                } else {
                    while (n >= 1) {
                        double d6;
                        if ((d6 = Math.abs(d2 + d3 * (double)n - this.doubleValue(n--))) <= d) continue;
                        return null;
                    }
                }
                return d3;
            }
            catch (ArithmeticException arithmeticException) {
                this.warning("increment", arithmeticException);
            }
        }
        return null;
    }

    public NumberRange<?> range() {
        return this.range(null, this.size());
    }

    NumberRange<?> range(IntSupplier intSupplier, int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        while (--n >= 0) {
            double d3 = this.doubleValue(intSupplier != null ? intSupplier.getAsInt() : n);
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return NumberRange.create(d, true, d2, true);
    }

    public final Vector subList(int n, int n2) {
        return this.subSampling(n, 1, n2 - n);
    }

    public Vector subSampling(int n, int n2, int n3) {
        int n4 = this.size();
        if (n2 == 1 && n == 0 && n3 == n4) {
            return this;
        }
        long l = (long)n + (long)n2 * ((long)n3 - 1L);
        if (n < 0 || n >= n4 || l < 0L || l >= (long)n4 || n3 < 0) {
            Object object;
            Object object2;
            short s;
            if (n2 == 1) {
                s = 60;
                object2 = n;
                object = l;
            } else {
                s = 45;
                object2 = "range";
                object = "[" + n + ':' + n2 + ':' + l + ']';
            }
            throw new IndexOutOfBoundsException(Errors.format(s, object2, object));
        }
        return this.createSubSampling(n, n2, n3);
    }

    Vector createSubSampling(int n, int n2, int n3) {
        return new SubSampling(n, n2, n3);
    }

    Vector backingVector() {
        return this;
    }

    int[] toBacking(int[] nArray) {
        nArray = (int[])nArray.clone();
        int n = this.size();
        for (int n2 : nArray) {
            ArgumentChecks.ensureValidIndex(n, n2);
        }
        return nArray;
    }

    public Vector pick(int ... nArray) {
        int n;
        int n2;
        nArray = this.toBacking(nArray);
        switch (nArray.length) {
            case 0: {
                n2 = 0;
                n = 1;
                break;
            }
            case 1: {
                n2 = nArray[0];
                n = 1;
                break;
            }
            default: {
                n2 = nArray[0];
                int n3 = nArray[1];
                n = n3 - n2;
                for (int i = 2; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    if (n4 - n3 != n) {
                        Vector vector = this.backingVector();
                        Objects.requireNonNull(vector);
                        return vector.new Pick(nArray);
                    }
                    n3 = n4;
                }
            }
        }
        return this.subSampling(n2, n, nArray.length);
    }

    public Vector concatenate(Vector vector) {
        if (vector.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return vector;
        }
        return this.createConcatenate(vector);
    }

    Vector createConcatenate(Vector vector) {
        return new ConcatenatedVector(this, vector);
    }

    public Vector repeat(boolean bl, int n) {
        switch (n) {
            case 0: {
                return this.subList(0, 0);
            }
            case 1: {
                return this;
            }
        }
        ArgumentChecks.ensurePositive("count", n);
        int n2 = this.size();
        return new RepeatedVector(this, bl ? n : 1, n2, Math.multiplyExact(n2, n));
    }

    public final Vector reverse() {
        int n = this.size();
        return n > 1 ? this.subSampling(n - 1, -1, n) : this;
    }

    public Vector transform(double d, double d2) {
        if (d == 1.0 && d2 == 0.0) {
            return this;
        }
        ArgumentChecks.ensureFinite("scale", d);
        ArgumentChecks.ensureFinite("offset", d2);
        if (d == 0.0) {
            return new SequenceVector.Doubles(Double.class, 0, 0, this.size());
        }
        return this.createTransform(d, d2);
    }

    Vector createTransform(double d, double d2) {
        return new LinearlyDerivedVector(this, d, d2);
    }

    public Vector compress(double d) {
        Object object;
        int n = this.size();
        Number number = this.increment(d);
        if (number != null) {
            return Vector.createSequence(this.getElementType(), this.get(0), number, n);
        }
        int n2 = 0;
        do {
            if (n2 < n) continue;
            Double d2 = Double.NaN;
            return Vector.createSequence(this.getElementType(), d2, d2, n);
        } while (this.isNaN(n2++));
        if (n > 640 / this.getBitCount()) {
            object = this.repetitions(MathFunctions.divisors(n));
            switch (((Object)object).length) {
                default: {
                    if (n - object[1] < n / 4) break;
                }
                case 1: {
                    return new RepeatedVector(this, (int[])object, d);
                }
                case 0: 
            }
        }
        if ((object = this.range()) != null && !((Range)object).isEmpty()) {
            Vector vector;
            boolean bl;
            Number number2 = (Number)((Range)object).getMinValue();
            Number number3 = (Number)((Range)object).getMaxValue();
            boolean bl2 = bl = number2.doubleValue() >= -9.223372036854776E18 && number3.doubleValue() <= 9.223372036854776E18 && this.isInteger();
            if (bl) {
                vector = PackedVector.compress(this, number2.longValue(), number3.longValue());
                if (vector == null) {
                    vector = ArrayVector.compress(this, number2.longValue(), number3.longValue());
                }
            } else {
                vector = ArrayVector.compress(this, d);
            }
            if (vector != null) {
                return vector;
            }
        }
        return this;
    }

    final void warning(String string, RuntimeException runtimeException) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.math"), Vector.class, string, runtimeException);
    }

    public Optional<Buffer> buffer() {
        return Optional.empty();
    }

    public double[] doubleValues() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.doubleValue(i);
        }
        return dArray;
    }

    public float[] floatValues() {
        float[] fArray = new float[this.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.floatValue(i);
        }
        return fArray;
    }

    final Vector copy() {
        Object[] objectArray;
        int n = this.size();
        switch (Numbers.getEnumConstant(this.getElementType())) {
            case 9: {
                objectArray = this.doubleValues();
                break;
            }
            case 8: {
                objectArray = this.floatValues();
                if (n == 0 || !(this.get(0) instanceof Double)) break;
                return Vector.createForDecimal((float[])objectArray);
            }
            case 6: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = this.longValue(i);
                }
                objectArray = lArray;
                break;
            }
            case 5: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (int)this.longValue(i);
                }
                objectArray = nArray;
                break;
            }
            case 4: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)this.intValue(i);
                }
                objectArray = sArray;
                break;
            }
            case 3: {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)this.intValue(i);
                }
                objectArray = byArray;
                break;
            }
            default: {
                objectArray = this.toArray(new Number[n]);
            }
        }
        return ArrayVector.newInstance(objectArray, this.isUnsigned());
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringJoiner.add(this.stringValue(i));
        }
        return stringJoiner.toString();
    }

    @Override
    public int hashCode() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + this.get(i).hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = this.size();
            if (n == vector.size()) {
                return this.equals(0, n, vector, 0);
            }
        }
        return false;
    }

    boolean equals(int n, int n2, Vector vector, int n3) {
        while (n < n2) {
            if (this.get(n++).equals(vector.get(n3++))) continue;
            return false;
        }
        return true;
    }

    private final class SubSampling
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 7641036842053528486L;
        final int first;
        final int step;
        final int length;

        SubSampling(int n, int n2, int n3) {
            this.first = n;
            this.step = n2;
            this.length = n3;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        final int toBacking(int n) {
            ArgumentChecks.ensureValidIndex(this.length, n);
            return n * this.step + this.first;
        }

        @Override
        int[] toBacking(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.toBacking(nArray[i]);
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public boolean isSinglePrecision() {
            return Vector.this.isSinglePrecision();
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.toBacking(n));
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.toBacking(n));
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.toBacking(n));
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.toBacking(n));
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.toBacking(n));
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.toBacking(n));
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.toBacking(n));
        }

        @Override
        public String stringValue(int n) {
            return Vector.this.stringValue(this.toBacking(n));
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.toBacking(n));
        }

        @Override
        public Number set(int n, Number number) {
            Number number2 = Vector.this.set(this.toBacking(n), number);
            ++this.modCount;
            return number2;
        }

        @Override
        Vector createTransform(double d, double d2) {
            return Vector.this.transform(d, d2).subSampling(this.first, this.step, this.length);
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            n = this.toBacking(n);
            return Vector.this.subSampling(n, n2 *= this.step, n3);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof SubSampling && vector.backingVector() == Vector.this) {
                SubSampling subSampling = (SubSampling)vector;
                if (subSampling.step == this.step && subSampling.first == this.first + this.step * this.length) {
                    return Vector.this.subSampling(this.first, this.step, this.length + subSampling.length);
                }
            }
            return super.createConcatenate(vector);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            if (intSupplier != null) {
                return Vector.this.range(() -> this.toBacking(intSupplier.getAsInt()), n);
            }
            IntSupplier intSupplier2 = null;
            if (this.first != 0 || this.step != 1) {
                intSupplier2 = new IntSupplier(){
                    private int index;
                    {
                        this.index = SubSampling.this.first;
                    }

                    @Override
                    public int getAsInt() {
                        int n = this.index;
                        this.index += SubSampling.this.step;
                        return n;
                    }
                };
            }
            return Vector.this.range(intSupplier2, n);
        }

        @Override
        public Vector compress(double d) {
            Vector vector = super.compress(d);
            return vector != this ? vector : this.copy();
        }

        @Override
        public Optional<Buffer> buffer() {
            if (this.step == 1) {
                Vector.this.buffer().map(buffer -> JDK9.slice(buffer.position(this.first).limit(this.first + this.length)));
            }
            return super.buffer();
        }
    }

    private final class Pick
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 6574040261355090760L;
        private final int[] indices;

        Pick(int[] nArray) {
            this.indices = nArray;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        @Override
        int[] toBacking(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.indices[nArray[i]];
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public boolean isSinglePrecision() {
            return Vector.this.isSinglePrecision();
        }

        @Override
        public int size() {
            return this.indices.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.indices[n]);
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.indices[n]);
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.indices[n]);
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.indices[n]);
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.indices[n]);
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.indices[n]);
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.indices[n]);
        }

        @Override
        public String stringValue(int n) {
            return Vector.this.stringValue(this.indices[n]);
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.indices[n]);
        }

        @Override
        public Number set(int n, Number number) {
            Number number2 = Vector.this.set(this.indices[n], number);
            ++this.modCount;
            return number2;
        }

        @Override
        Vector createTransform(double d, double d2) {
            return Vector.this.transform(d, d2).pick(this.indices);
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            int[] nArray = new int[n3];
            if (n2 == 1) {
                System.arraycopy(this.indices, n, nArray, 0, n3);
            } else {
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.indices[n];
                    n += n2;
                }
            }
            return Vector.this.pick(nArray);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof Pick && vector.backingVector() == Vector.this) {
                int[] nArray = ((Pick)vector).indices;
                int[] nArray2 = Arrays.copyOf(this.indices, this.indices.length + nArray.length);
                System.arraycopy(nArray, 0, nArray2, this.indices.length, nArray.length);
                return Vector.this.pick(nArray2);
            }
            return super.createConcatenate(vector);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            if (intSupplier != null) {
                return Vector.this.range(() -> this.indices[intSupplier.getAsInt()], n);
            }
            return Vector.this.range(new IntSupplier(){
                private int index;

                @Override
                public int getAsInt() {
                    return Pick.this.indices[this.index++];
                }
            }, n);
        }

        @Override
        public Vector compress(double d) {
            Vector vector = super.compress(d);
            return vector != this ? vector : this.copy();
        }
    }
}

