/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.concurrent.Callable;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;

public interface IndexFieldDataCache {
    public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(AtomicReaderContext var1, IFD var2) throws Exception;

    public void clear();

    public void clear(String var1);

    public void clear(Object var1);

    public static class Soft
    extends FieldBased {
        public Soft(@Nullable IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
            super(indexService, fieldNames, fieldDataType, CacheBuilder.newBuilder().softValues());
        }
    }

    public static class Resident
    extends FieldBased {
        public Resident(@Nullable IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
            super(indexService, fieldNames, fieldDataType, CacheBuilder.newBuilder());
        }
    }

    public static abstract class FieldBased
    implements IndexFieldDataCache,
    SegmentReader.CoreClosedListener,
    RemovalListener<Key, AtomicFieldData> {
        @Nullable
        private final IndexService indexService;
        private final FieldMapper.Names fieldNames;
        private final FieldDataType fieldDataType;
        private final Cache<Key, AtomicFieldData> cache;

        protected FieldBased(@Nullable IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType, CacheBuilder cache) {
            this.indexService = indexService;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
            cache.removalListener(this);
            this.cache = cache.build();
        }

        @Override
        public void onRemoval(RemovalNotification<Key, AtomicFieldData> notification) {
            Key key = notification.getKey();
            if (key == null || key.listener == null) {
                return;
            }
            AtomicFieldData value = notification.getValue();
            long sizeInBytes = key.sizeInBytes;
            if (sizeInBytes == -1L && value != null) {
                sizeInBytes = value.getMemorySizeInBytes();
            }
            key.listener.onUnload(this.fieldNames, this.fieldDataType, notification.wasEvicted(), sizeInBytes, value);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final AtomicReaderContext context, final IFD indexFieldData) throws Exception {
            final Key key = new Key(context.reader().getCoreCacheKey());
            return (FD)this.cache.get(key, new Callable<AtomicFieldData>(){

                @Override
                public AtomicFieldData call() throws Exception {
                    IndexShard shard;
                    ShardId shardId;
                    SegmentReaderUtils.registerCoreListener(context.reader(), FieldBased.this);
                    Object fieldData = indexFieldData.loadDirect(context);
                    key.sizeInBytes = fieldData.getMemorySizeInBytes();
                    if (FieldBased.this.indexService != null && (shardId = ShardUtils.extractShardId(context.reader())) != null && (shard = FieldBased.this.indexService.shard(shardId.id())) != null) {
                        key.listener = shard.fieldData();
                    }
                    if (key.listener != null) {
                        key.listener.onLoad(FieldBased.this.fieldNames, FieldBased.this.fieldDataType, (AtomicFieldData)fieldData);
                    }
                    return fieldData;
                }
            });
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }

        @Override
        public void clear(String fieldName) {
            this.cache.invalidateAll();
        }

        @Override
        public void clear(Object coreCacheKey) {
            this.cache.invalidate(new Key(coreCacheKey));
        }

        public void onClose(Object coreCacheKey) {
            this.cache.invalidate(new Key(coreCacheKey));
        }

        static class Key {
            final Object readerKey;
            @Nullable
            Listener listener;
            long sizeInBytes = -1L;

            Key(Object readerKey) {
                this.readerKey = readerKey;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                Key key = (Key)o;
                return this.readerKey.equals(key.readerKey);
            }

            public int hashCode() {
                return this.readerKey.hashCode();
            }
        }
    }

    public static interface Listener {
        public void onLoad(FieldMapper.Names var1, FieldDataType var2, AtomicFieldData var3);

        public void onUnload(FieldMapper.Names var1, FieldDataType var2, boolean var3, long var4, @Nullable AtomicFieldData var6);
    }
}

