/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum VersionType {
    INTERNAL(0){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            return currentVersion != -2L && expectedVersion != 0L && (currentVersion == -1L || currentVersion != expectedVersion);
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return currentVersion == -2L || currentVersion == -1L ? 1L : currentVersion + 1L;
        }
    }
    ,
    EXTERNAL(1){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            return currentVersion != -2L && currentVersion != -1L && (expectedVersion == 0L || currentVersion >= expectedVersion);
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }
    };

    private final byte value;

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract boolean isVersionConflict(long var1, long var3);

    public abstract long updateVersion(long var1, long var3);

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + value + "]");
    }
}

