/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.lang.reflect.Field;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;

public class SegmentReaderUtils {
    private static final Field FILTER_ATOMIC_READER_IN;

    @Nullable
    public static SegmentReader segmentReader(AtomicReader reader) {
        return SegmentReaderUtils.internalSegmentReader(reader, true);
    }

    @Nullable
    public static SegmentReader segmentReaderOrNull(AtomicReader reader) {
        return SegmentReaderUtils.internalSegmentReader(reader, false);
    }

    public static boolean registerCoreListener(AtomicReader reader, SegmentReader.CoreClosedListener listener) {
        SegmentReader segReader = SegmentReaderUtils.segmentReaderOrNull(reader);
        if (segReader != null) {
            segReader.addCoreClosedListener(listener);
            return true;
        }
        return false;
    }

    private static SegmentReader internalSegmentReader(AtomicReader reader, boolean fail) {
        if (reader == null) {
            return null;
        }
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterAtomicReader) {
            FilterAtomicReader fReader = (FilterAtomicReader)reader;
            try {
                return FILTER_ATOMIC_READER_IN == null ? null : SegmentReaderUtils.segmentReader((AtomicReader)FILTER_ATOMIC_READER_IN.get(fReader));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (fail) {
            throw new ElasticsearchIllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
        }
        return null;
    }

    static {
        Field in;
        block2: {
            in = null;
            try {
                in = FilterAtomicReader.class.getDeclaredField("in");
                in.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Failed to get field: " + e.getMessage()));
            }
        }
        FILTER_ATOMIC_READER_IN = in;
    }
}

