/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.io.UnsupportedEncodingException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmPmglHeader
implements ChmAccessor<ChmPmglHeader> {
    private static final long serialVersionUID = -6139486487475923593L;
    private byte[] signature;
    private long free_space;
    private long unknown_0008;
    private int block_prev;
    private int block_next;
    private int dataRemained;
    private int currentPlace = 0;

    public ChmPmglHeader() {
        try {
            this.signature = "PMGL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported.");
        }
    }

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int dataRemained) {
        this.dataRemained = dataRemained;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int currentPlace) {
        this.currentPlace = currentPlace;
    }

    public long getFreeSpace() {
        return this.free_space;
    }

    public void setFreeSpace(long free_space) throws TikaException {
        if (free_space < 0L) {
            throw new TikaException("Bad PMGLheader.FreeSpace=" + free_space);
        }
        this.free_space = free_space;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("signatute:=" + new String(this.getSignature(), "UTF-8") + ", ");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported.");
        }
        sb.append("free space:=" + this.getFreeSpace() + ", ");
        sb.append("unknown0008:=" + this.getUnknown0008() + ", ");
        sb.append("prev block:=" + this.getBlockPrev() + ", ");
        sb.append("next block:=" + this.getBlockNext() + System.getProperty("line.separator"));
        return sb.toString();
    }

    protected void unmarshalCharArray(byte[] data, ChmPmglHeader chmPmglHeader, int count) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        this.setDataRemained(data.length);
        System.arraycopy(data, 0, chmPmglHeader.signature, 0, count);
        this.setCurrentPlace(this.getCurrentPlace() + count);
        this.setDataRemained(this.getDataRemained() - count);
    }

    private int unmarshalInt32(byte[] data) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        int dest = data[this.getCurrentPlace()] & 0xFF | (data[this.getCurrentPlace() + 1] & 0xFF) << 8 | (data[this.getCurrentPlace() + 2] & 0xFF) << 16 | (data[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        this.setDataRemained(this.getDataRemained() - 4);
        return dest;
    }

    private long unmarshalUInt32(byte[] data) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(data);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        long dest = data[this.getCurrentPlace()] & 0xFF | (data[this.getCurrentPlace() + 1] & 0xFF) << 8 | (data[this.getCurrentPlace() + 2] & 0xFF) << 16 | (data[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return dest;
    }

    @Override
    public void parse(byte[] data, ChmPmglHeader chmPmglHeader) throws TikaException {
        if (data.length < 20) {
            throw new TikaException(ChmPmglHeader.class.getName() + " we only know how to deal with a 0x14 byte structures");
        }
        chmPmglHeader.unmarshalCharArray(data, chmPmglHeader, 4);
        chmPmglHeader.setFreeSpace(chmPmglHeader.unmarshalUInt32(data));
        chmPmglHeader.setUnknown0008(chmPmglHeader.unmarshalUInt32(data));
        chmPmglHeader.setBlockPrev(chmPmglHeader.unmarshalInt32(data));
        chmPmglHeader.setBlockNext(chmPmglHeader.unmarshalInt32(data));
        try {
            if (!new String(chmPmglHeader.getSignature(), "UTF-8").equals("PMGL")) {
                throw new ChmParsingException(ChmPmglHeader.class.getName() + " pmgl != pmgl.signature");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported.");
        }
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public long getUnknown0008() {
        return this.unknown_0008;
    }

    protected void setUnknown0008(long unknown_0008) {
        this.unknown_0008 = unknown_0008;
    }

    public int getBlockPrev() {
        return this.block_prev;
    }

    protected void setBlockPrev(int block_prev) {
        this.block_prev = block_prev;
    }

    public int getBlockNext() {
        return this.block_next;
    }

    protected void setBlockNext(int block_next) {
        this.block_next = block_next;
    }
}

