/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class FileUtils {
    public static void create(File f) {
        if (f.exists()) {
            return;
        }
        Utils.safe(() -> Utils.opt(f.createNewFile()).filter(x -> x).orElseThrow(() -> ThrowableUtils.rex("Could not create file ''{0}''", f.getAbsolutePath())));
    }

    public static File createTempFile(String name) throws IOException {
        String[] parts = name.split("\\.");
        File f = File.createTempFile(parts[0], "." + parts[1]);
        f.deleteOnExit();
        return f;
    }

    public static File createTempFile(String name, String contents) throws IOException {
        File f = FileUtils.createTempFile(name);
        if (contents != null) {
            try (StringReader r = new StringReader(contents);
                 FileWriter w = new FileWriter(f);){
                IoUtils.pipe((Reader)r, (Writer)w);
                ((Writer)w).flush();
            }
        }
        return f;
    }

    public static boolean deleteFile(File f) {
        File[] cf;
        if (f == null) {
            return true;
        }
        if (f.isDirectory() && Utils.nn(cf = f.listFiles())) {
            for (File c : cf) {
                FileUtils.deleteFile(c);
            }
        }
        return f.delete();
    }

    public static boolean fileExists(File dir, String fileName) {
        if (dir == null || fileName == null) {
            return false;
        }
        return Files.exists(dir.toPath().resolve(fileName), new LinkOption[0]);
    }

    public static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getFileExtension(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static String getFileName(String path) {
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        if (StringUtils.isEmpty(path = StringUtils.trimTrailingSlashes(path))) {
            return null;
        }
        int i = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return i == -1 ? path : path.substring(i + 1);
    }

    public static boolean hasExtension(String name, String ext) {
        if (name == null || ext == null) {
            return false;
        }
        return ext.equals(FileUtils.getFileExtension(name));
    }

    public static File mkdirs(File f, boolean clean) {
        AssertionUtils.assertArgNotNull("f", f);
        if (f.exists()) {
            if (clean) {
                Utils.opt(FileUtils.deleteFile(f)).filter(x -> x).orElseThrow(() -> ThrowableUtils.rex("Could not clean directory ''{0}''", f.getAbsolutePath()));
            } else {
                return f;
            }
        }
        Utils.opt(f.mkdirs()).filter(x -> x).orElseThrow(() -> ThrowableUtils.rex("Could not create directory ''{0}''", f.getAbsolutePath()));
        return f;
    }

    public static File mkdirs(String path, boolean clean) {
        AssertionUtils.assertArgNotNull("path", path);
        return FileUtils.mkdirs(new File(path), clean);
    }

    public static void modifyTimestamp(File f) {
        long l;
        long lm = f.lastModified();
        if (lm == (l = System.currentTimeMillis())) {
            ++l;
        }
        Utils.opt(f.setLastModified(l)).filter(x -> x).orElseThrow(() -> ThrowableUtils.rex("Could not modify timestamp on file ''{0}''", f.getAbsolutePath()));
        if (lm == f.lastModified()) {
            Utils.opt(f.setLastModified(l + 1000L)).filter(x -> x).orElseThrow(() -> ThrowableUtils.rex("Could not modify timestamp on file ''{0}''", f.getAbsolutePath()));
        }
    }
}

