/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser.annotation;

import java.nio.charset.Charset;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.parser.annotation.ParserConfig;
import org.apache.juneau.svl.VarResolverSession;

public class ParserConfigAnnotation {

    public static class ReaderParserApply
    extends AnnotationApplier<ParserConfig, ReaderParser.Builder> {
        public ReaderParserApply(VarResolverSession vr) {
            super(ParserConfig.class, ReaderParser.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<ParserConfig> ai, ReaderParser.Builder b) {
            ParserConfig a = ai.inner();
            this.charset(a.fileCharset()).ifPresent(x -> b.fileCharset((Charset)x));
            this.charset(a.streamCharset()).ifPresent(x -> b.streamCharset((Charset)x));
        }
    }

    public static class ParserApply
    extends AnnotationApplier<ParserConfig, Parser.Builder> {
        public ParserApply(VarResolverSession vr) {
            super(ParserConfig.class, Parser.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<ParserConfig> ai, Parser.Builder b) {
            ParserConfig a = ai.inner();
            this.bool(a.autoCloseStreams()).ifPresent(x -> b.autoCloseStreams((boolean)x));
            this.integer(a.debugOutputLines(), "debugOutputLines").ifPresent(x -> b.debugOutputLines((int)x));
            this.type(a.listener()).ifPresent(x -> b.listener((Class<? extends ParserListener>)x));
            this.bool(a.strict()).ifPresent(x -> b.strict((boolean)x));
            this.bool(a.trimStrings()).ifPresent(x -> b.trimStrings((boolean)x));
            this.bool(a.unbuffered()).ifPresent(x -> b.unbuffered((boolean)x));
        }
    }

    public static class InputStreamParserApply
    extends AnnotationApplier<ParserConfig, InputStreamParser.Builder> {
        public InputStreamParserApply(VarResolverSession vr) {
            super(ParserConfig.class, InputStreamParser.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<ParserConfig> ai, InputStreamParser.Builder b) {
            ParserConfig a = ai.inner();
            this.string(a.binaryFormat()).map(BinaryFormat::valueOf).ifPresent(x -> b.binaryFormat((BinaryFormat)((Object)x)));
        }
    }
}

