/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.msgpack.annotation.MsgPack;
import org.apache.juneau.svl.VarResolverSession;

public class MsgPackAnnotation {
    public static final MsgPack DEFAULT = MsgPackAnnotation.create().build();

    public static MsgPack copy(MsgPack a, VarResolverSession r) {
        return ((Builder)MsgPackAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return MsgPackAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return MsgPackAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private String[] description = new String[0];

        protected Builder() {
            super(MsgPack.class);
        }

        public MsgPack build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements MsgPack {
        private final String[] description;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public MsgPack[] value();
    }

    public static class Apply
    extends AnnotationApplier<MsgPack, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(MsgPack.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<MsgPack> ai, Context.Builder b) {
            MsgPack a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on()) && CollectionUtils.isEmptyArray(a.onClass())) {
                return;
            }
            b.annotations(MsgPackAnnotation.copy(a, this.vr()));
        }
    }
}

