/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.juneau.commons.utils.AssertionUtils;

public class FluentMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> map;

    public FluentMap(Map<K, V> inner) {
        this.map = AssertionUtils.assertArgNotNull("inner", inner);
    }

    public FluentMap<K, V> a(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public FluentMap<K, V> aa(Map<? extends K, ? extends V> m) {
        if (m != null) {
            this.map.putAll(m);
        }
        return this;
    }

    public FluentMap<K, V> ai(boolean condition, K key, V value) {
        if (condition) {
            this.map.put(key, value);
        }
        return this;
    }

    public FluentMap<K, V> ai(Predicate<V> predicate, K key, V value) {
        if (predicate.test(value)) {
            this.map.put(key, value);
        }
        return this;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

