/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public abstract class ElementInfo {
    private final int modifiers;

    protected ElementInfo(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.PUBLIC -> this.isPublic();
            case ElementFlag.NOT_PUBLIC -> this.isNotPublic();
            case ElementFlag.PRIVATE -> this.isPrivate();
            case ElementFlag.NOT_PRIVATE -> this.isNotPrivate();
            case ElementFlag.PROTECTED -> this.isProtected();
            case ElementFlag.NOT_PROTECTED -> this.isNotProtected();
            case ElementFlag.STATIC -> this.isStatic();
            case ElementFlag.NOT_STATIC -> this.isNotStatic();
            case ElementFlag.FINAL -> this.isFinal();
            case ElementFlag.NOT_FINAL -> this.isNotFinal();
            case ElementFlag.SYNCHRONIZED -> this.isSynchronized();
            case ElementFlag.NOT_SYNCHRONIZED -> this.isNotSynchronized();
            case ElementFlag.VOLATILE -> this.isVolatile();
            case ElementFlag.NOT_VOLATILE -> this.isNotVolatile();
            case ElementFlag.TRANSIENT -> this.isTransient();
            case ElementFlag.NOT_TRANSIENT -> this.isNotTransient();
            case ElementFlag.NATIVE -> this.isNative();
            case ElementFlag.NOT_NATIVE -> this.isNotNative();
            case ElementFlag.INTERFACE -> this.isInterface();
            case ElementFlag.ABSTRACT -> this.isAbstract();
            case ElementFlag.NOT_ABSTRACT -> this.isNotAbstract();
            default -> throw ThrowableUtils.rex("Invalid flag for element: {0}", new Object[]{flag});
        };
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isAll(ElementFlag ... flags) {
        return CollectionUtils.stream(flags).allMatch(this::is);
    }

    public boolean isAny(ElementFlag ... flags) {
        return CollectionUtils.stream(flags).anyMatch(this::is);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean isNotAbstract() {
        return !Modifier.isAbstract(this.modifiers);
    }

    public boolean isNotFinal() {
        return !Modifier.isFinal(this.modifiers);
    }

    public boolean isNotInterface() {
        return !Modifier.isInterface(this.modifiers);
    }

    public boolean isNotNative() {
        return !Modifier.isNative(this.modifiers);
    }

    public boolean isNotPrivate() {
        return !Modifier.isPrivate(this.modifiers);
    }

    public boolean isNotProtected() {
        return !Modifier.isProtected(this.modifiers);
    }

    public boolean isNotPublic() {
        return !Modifier.isPublic(this.modifiers);
    }

    public boolean isNotStatic() {
        return !Modifier.isStatic(this.modifiers);
    }

    public boolean isNotSynchronized() {
        return !Modifier.isSynchronized(this.modifiers);
    }

    public boolean isNotTransient() {
        return !Modifier.isTransient(this.modifiers);
    }

    public boolean isNotVolatile() {
        return !Modifier.isVolatile(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    protected <A extends Annotation> AnnotationInfo<A> ai(Annotatable on, A value) {
        return AnnotationInfo.of(on, value);
    }
}

