/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Xml
extends OpenApiElement {
    private String name;
    private String namespace;
    private String prefix;
    private Boolean attribute;
    private Boolean wrapped;

    public Xml() {
    }

    public Xml(Xml copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.namespace = copyFrom.namespace;
        this.prefix = copyFrom.prefix;
        this.attribute = copyFrom.attribute;
        this.wrapped = copyFrom.wrapped;
    }

    public Xml copy() {
        return new Xml(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "name" -> ConverterUtils.toType((Object)this.getName(), type);
            case "namespace" -> ConverterUtils.toType((Object)this.getNamespace(), type);
            case "prefix" -> ConverterUtils.toType((Object)this.getPrefix(), type);
            case "attribute" -> ConverterUtils.toType((Object)this.getAttribute(), type);
            case "wrapped" -> ConverterUtils.toType((Object)this.getWrapped(), type);
            default -> super.get(property, type);
        });
    }

    public Boolean getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Boolean getWrapped() {
        return this.wrapped;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.attribute), (Object)"attribute").addIf(Utils.nn((Object)this.name), (Object)"name").addIf(Utils.nn((Object)this.namespace), (Object)"namespace").addIf(Utils.nn((Object)this.prefix), (Object)"prefix").addIf(Utils.nn((Object)this.wrapped), (Object)"wrapped").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Xml set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "attribute" -> this.setAttribute(ConverterUtils.toBoolean((Object)value));
            case "name" -> this.setName(Utils.s((Object)value));
            case "namespace" -> this.setNamespace(Utils.s((Object)value));
            case "prefix" -> this.setPrefix(Utils.s((Object)value));
            case "wrapped" -> this.setWrapped(ConverterUtils.toBoolean((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Xml setAttribute(Boolean value) {
        this.attribute = value;
        return this;
    }

    public Xml setName(String value) {
        this.name = value;
        return this;
    }

    public Xml setNamespace(String value) {
        this.namespace = value;
        return this;
    }

    public Xml setPrefix(String value) {
        this.prefix = value;
        return this;
    }

    public Xml setWrapped(Boolean value) {
        this.wrapped = value;
        return this;
    }

    @Override
    public Xml strict() {
        super.strict();
        return this;
    }

    @Override
    public Xml strict(Object value) {
        super.strict(value);
        return this;
    }
}

