/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.JAXBContext;

enum Implementation {
    GLASSFISH("org.glassfish.jaxb.indentString"),
    ENDORSED("com.sun.xml.bind.indentString"),
    OTHER(null);

    private static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private static final String GLASSFISH_PREFIX = "org.glassfish.jaxb.";
    final String indentKey;

    private Implementation(String indentKey) {
        this.indentKey = indentKey;
    }

    public static Implementation detect(JAXBContext context2) {
        if (context2 != null) {
            String classname = context2.getClass().getName();
            if (classname.startsWith(GLASSFISH_PREFIX)) {
                return GLASSFISH;
            }
            if (classname.startsWith(ENDORSED_PREFIX)) {
                return ENDORSED;
            }
        }
        return OTHER;
    }

    boolean filterProperty(String key) {
        return this.indentKey != null || !key.startsWith(ENDORSED_PREFIX);
    }
}

