/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import org.apache.lucene.search.uhighlight.CharArrayMatcher;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

public interface LabelledCharArrayMatcher
extends CharArrayMatcher {
    public String getLabel();

    public static LabelledCharArrayMatcher wrap(final String label, final CharArrayMatcher in) {
        return new LabelledCharArrayMatcher(){

            @Override
            public String getLabel() {
                return label;
            }

            @Override
            public boolean match(char[] s, int offset, int length) {
                return in.match(s, offset, length);
            }
        };
    }

    public static LabelledCharArrayMatcher wrap(String label, ByteRunAutomaton runAutomaton) {
        return LabelledCharArrayMatcher.wrap(label, (char[] chars, int offset, int length) -> {
            int state = 0;
            int maxIdx = offset + length;
            for (int i = offset; i < maxIdx; ++i) {
                char code = chars[i];
                if (code < '\u0080') {
                    if ((state = runAutomaton.step(state, code)) != -1) continue;
                    return false;
                }
                if (code < '\u0800') {
                    int b = 0xC0 | code >> 6;
                    if ((state = runAutomaton.step(state, b)) == -1) {
                        return false;
                    }
                    b = 0x80 | code & 0x3F;
                    if ((state = runAutomaton.step(state, b)) != -1) continue;
                    return false;
                }
                byte[] utf8Bytes = new byte[4 * (maxIdx - i)];
                int utf8Len = UnicodeUtil.UTF16toUTF8(chars, i, maxIdx - i, utf8Bytes);
                for (int utfIdx = 0; utfIdx < utf8Len; ++utfIdx) {
                    if ((state = runAutomaton.step(state, utf8Bytes[utfIdx] & 0xFF)) != -1) continue;
                    return false;
                }
                break;
            }
            return runAutomaton.isAccept(state);
        });
    }
}

