/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import org.apache.jena.iri.impl.AbsIRIImpl;
import org.apache.jena.iri.impl.IRIFactoryImpl;
import org.apache.jena.iri.impl.Parser;
import org.apache.jena.iri.impl.SchemeSpecificPart;

public class ResolvedRelativeIRI
extends AbsIRIImpl {
    private final AbsIRIImpl base;
    private final AbsIRIImpl rel;
    int useBaseUntilThisComponent;
    long pathErrors;
    final String iri;

    public ResolvedRelativeIRI(AbsIRIImpl base, AbsIRIImpl rel) {
        this.base = base;
        this.rel = rel;
        this.transformReferences();
        this.iri = this.createIRIString();
        this.allErrors = 0L;
        for (int i = 0; i < Parser.fields.length; ++i) {
            this.allErrors |= this.errors(Parser.fields[i]);
        }
    }

    private void transformReferences() {
        this.pathErrors = 0L;
        this.path = null;
        if (!(!this.rel.has(2) || this.getFactory().getSameSchemaRelativeReferences(this.rel.getScheme()) && this.base.has(2) && this.rel.getScheme().equalsIgnoreCase(this.base.getScheme()))) {
            this.useBaseUntilThisComponent = 2;
        } else if (this.rel.has(4)) {
            this.useBaseUntilThisComponent = 4;
        } else {
            String rPath = this.rel.getRawPath();
            if (rPath.equals("")) {
                this.useBaseUntilThisComponent = this.rel.has(13) ? 13 : 15;
            } else if (rPath.charAt(0) == '/') {
                this.useBaseUntilThisComponent = 11;
            } else {
                this.useBaseUntilThisComponent = 11;
                this.path = this.mergePathsRemoveDots();
                this.pathErrors = this.base.errors(11);
            }
        }
        if (this.useBaseUntilThisComponent <= 11) {
            this.pathErrors |= this.rel.errors(11);
            if (this.path == null) {
                this.path = this.rel.pathRemoveDots();
            }
        } else {
            this.pathErrors |= this.base.errors(11);
            this.path = this.base.getRawPath();
        }
    }

    private String createIRIString() {
        StringBuilder iriBuf = new StringBuilder();
        if (this.has(2)) {
            iriBuf.append(this.getScheme());
            iriBuf.append(':');
        }
        if (this.has(4)) {
            iriBuf.append("//");
            iriBuf.append(this.getRawAuthority());
        }
        iriBuf.append(this.getRawPath());
        if (this.has(13)) {
            iriBuf.append('?');
            iriBuf.append(this.getRawQuery());
        }
        if (this.has(15)) {
            iriBuf.append('#');
            iriBuf.append(this.getRawFragment());
        }
        return iriBuf.toString();
    }

    private String mergePathsRemoveDots() {
        if (this.base.has(4) && this.base.getRawPath().equals("")) {
            return this.mergePathsRemoveDots("/");
        }
        return this.mergePathsRemoveDots(this.base.getRawPath());
    }

    private String mergePathsRemoveDots(String basePath) {
        int slash = basePath.lastIndexOf(47);
        StringBuilder output = new StringBuilder();
        if (slash != -1) {
            output.append(basePath.substring(0, slash + 1));
        }
        if (this.base.dotsOK() && this.rel.dotsOK()) {
            String relPath = this.rel.getRawPath();
            if (relPath.startsWith("./")) {
                relPath = relPath.substring(2);
            }
            while (relPath.startsWith("../")) {
                relPath = relPath.substring(3);
                ResolvedRelativeIRI.removeLastSeqment2(output);
            }
            if (relPath.equals("..")) {
                relPath = "";
                ResolvedRelativeIRI.removeLastSeqment2(output);
            }
            if (relPath.equals(".")) {
                relPath = "";
            }
            output.append(relPath);
            return output.toString();
        }
        output.append(this.rel.getRawPath());
        return ResolvedRelativeIRI.removeDotSegments(output.toString());
    }

    private static void removeLastSeqment2(StringBuilder output) {
        int ix = output.length() - 1;
        if (ix <= 0) {
            return;
        }
        while (ix > 0) {
            if (output.charAt(--ix) != '/') continue;
            ++ix;
            break;
        }
        output.setLength(ix);
    }

    @Override
    protected IRIFactoryImpl getFactory() {
        return this.base.getFactory();
    }

    @Override
    long errors(int field) {
        return field == 11 ? this.pathErrors : (field < this.useBaseUntilThisComponent ? this.base.errors(field) : this.rel.errors(field));
    }

    @Override
    boolean has(int field) {
        return field == 11 || (field < this.useBaseUntilThisComponent ? this.base.has(field) : this.rel.has(field));
    }

    @Override
    String get(int field) {
        return field == 11 ? this.path : (field < this.useBaseUntilThisComponent ? this.base.get(field) : this.rel.get(field));
    }

    @Override
    public String toString() {
        return this.iri;
    }

    @Override
    String pathRemoveDots() {
        return this.useBaseUntilThisComponent > 11 ? this.base.pathRemoveDots() : this.path;
    }

    @Override
    boolean dotsOK() {
        return true;
    }

    @Override
    SchemeSpecificPart getSchemeSpec() {
        if (this.useBaseUntilThisComponent == 2) {
            return this.rel.getSchemeSpec();
        }
        return this.base.getSchemeSpec();
    }

    @Override
    Exception getIDNAException() {
        if (this.useBaseUntilThisComponent == 2 || this.useBaseUntilThisComponent == 4) {
            return this.rel.getIDNAException();
        }
        return this.base.getIDNAException();
    }
}

