/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Graph;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.Push;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;

public class HttpRDF {
    public static Graph httpGetGraph(String url) {
        return HttpRDF.httpGetGraph(HttpEnv.getDftHttpClient(), url);
    }

    public static Graph httpGetGraph(String url, String acceptHeader) {
        return HttpRDF.httpGetGraph(HttpEnv.getDftHttpClient(), url, acceptHeader);
    }

    public static Graph httpGetGraph(HttpClient httpClient, String url) {
        Graph graph = GraphFactory.createDefaultGraph();
        HttpRDF.httpGetToStream(httpClient, url, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3", StreamRDFLib.graph(graph));
        return graph;
    }

    public static Graph httpGetGraph(HttpClient httpClient, String url, String acceptHeader) {
        Graph graph = GraphFactory.createDefaultGraph();
        HttpRDF.httpGetToStream(httpClient, url, acceptHeader, StreamRDFLib.graph(graph));
        return graph;
    }

    public static void httpGetToStream(String url, String acceptHeader, StreamRDF dest) {
        HttpRDF.httpGetToStream(HttpEnv.getDftHttpClient(), url, acceptHeader, dest);
    }

    public static void httpGetToStream(HttpClient client, String url, String acceptHeader, StreamRDF dest) {
        if (acceptHeader == null) {
            acceptHeader = "*/*";
        }
        HttpRDF.httpGetToStream(client, url, HttpLib.setAcceptHeader(acceptHeader), dest);
    }

    public static void httpGetToStream(HttpClient client, String url, Map<String, String> headers, StreamRDF dest) {
        HttpRDF.httpGetToStream(client, url, HttpLib.setHeaders(headers), dest);
    }

    private static void httpGetToStream(HttpClient client, String url, Consumer<HttpRequest.Builder> modifier, StreamRDF dest) {
        HttpResponse<InputStream> response = HttpRDF.execGetToInput(client, url, modifier);
        HttpRDF.httpResponseToStreamRDF(url, response, dest);
    }

    static void httpResponseToStreamRDF(String url, HttpResponse<InputStream> response, StreamRDF dest) {
        InputStream in = HttpLib.handleResponseInputStream(response);
        String base = HttpRDF.determineBaseURI(url, response);
        Lang lang = HttpRDF.determineSyntax(response, Lang.RDFXML);
        try {
            RDFParser.create().base(base).source(in).lang(lang).parse(dest);
        }
        catch (RiotParseException ex) {
            throw ex;
        }
        finally {
            HttpLib.finishInputStream(in);
        }
    }

    private static HttpResponse<InputStream> execGetToInput(HttpClient client, String url, Consumer<HttpRequest.Builder> modifier) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(url);
        HttpRequest requestData = HttpLib.newGetRequest(url, modifier);
        HttpResponse<InputStream> response = HttpLib.execute(client, requestData);
        HttpLib.handleHttpStatusCode(response);
        return response;
    }

    public static void httpPostGraph(String url, Graph graph) {
        HttpRDF.httpPostGraph(HttpEnv.getDftHttpClient(), url, graph, HttpEnv.defaultTriplesFormat);
    }

    public static void httpPostGraph(HttpClient httpClient, String url, Graph graph, RDFFormat format) {
        HttpRDF.httpPostGraph(httpClient, url, graph, format, null);
    }

    public static void httpPostGraph(HttpClient httpClient, String url, Graph graph, RDFFormat format, Map<String, String> httpHeaders) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRDF.graphToHttpBody(graph, format);
        HttpRDF.pushBody(httpClient, url, Push.POST, bodyPublisher, format, httpHeaders);
    }

    public static Graph httpPostGraphRtn(String url, Graph graph) {
        return HttpRDF.httpPostGraphRtn(HttpEnv.getDftHttpClient(), url, graph, HttpEnv.defaultTriplesFormat, null);
    }

    public static Graph httpPostGraphRtn(HttpClient httpClient, String url, Graph graph, RDFFormat format, Map<String, String> httpHeaders) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRDF.graphToHttpBody(graph, HttpEnv.defaultTriplesFormat);
        HttpResponse<InputStream> httpResponse = HttpRDF.pushWithResponse(httpClient, url, Push.POST, bodyPublisher, format, httpHeaders);
        Graph graphResponse = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(graphResponse);
        HttpRDF.httpResponseToStreamRDF(url, httpResponse, dest);
        return graphResponse;
    }

    public static void httpPostDataset(HttpClient httpClient, String url, DatasetGraph dataset, RDFFormat format) {
        HttpRDF.httpPostDataset(httpClient, url, dataset, format, null);
    }

    public static void httpPostDataset(HttpClient httpClient, String url, DatasetGraph dataset, RDFFormat format, Map<String, String> httpHeaders) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRDF.datasetToHttpBody(dataset, format);
        HttpRDF.pushBody(httpClient, url, Push.POST, bodyPublisher, format, httpHeaders);
    }

    public static void httpPutGraph(String url, Graph graph) {
        HttpRDF.httpPutGraph(HttpEnv.getDftHttpClient(), url, graph, HttpEnv.defaultTriplesFormat);
    }

    public static void httpPutGraph(HttpClient httpClient, String url, Graph graph, RDFFormat fmt) {
        HttpRDF.httpPutGraph(httpClient, url, graph, fmt, null);
    }

    public static void httpPutGraph(HttpClient httpClient, String url, Graph graph, RDFFormat format, Map<String, String> httpHeaders) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRDF.graphToHttpBody(graph, format);
        HttpRDF.pushBody(httpClient, url, Push.PUT, bodyPublisher, format, httpHeaders);
    }

    public static void httpPutDataset(HttpClient httpClient, String url, DatasetGraph dataset, RDFFormat format) {
        HttpRDF.httpPutDataset(httpClient, url, dataset, format, null);
    }

    public static void httpPutDataset(HttpClient httpClient, String url, DatasetGraph dataset, RDFFormat format, Map<String, String> httpHeaders) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRDF.datasetToHttpBody(dataset, format);
        HttpRDF.pushBody(httpClient, url, Push.PUT, bodyPublisher, format, httpHeaders);
    }

    private static void pushBody(HttpClient httpClient, String url, Push style, HttpRequest.BodyPublisher bodyPublisher, RDFFormat format, Map<String, String> httpHeaders) {
        String contentType = format.getLang().getHeaderString();
        if (httpHeaders == null) {
            httpHeaders = Collections.singletonMap("Content-Type", contentType);
        } else {
            httpHeaders.put("Content-Type", contentType);
        }
        HttpLib.httpPushData(httpClient, style, url, HttpLib.setHeaders(httpHeaders), bodyPublisher);
    }

    private static HttpResponse<InputStream> pushWithResponse(HttpClient httpClient, String url, Push style, HttpRequest.BodyPublisher bodyPublisher, RDFFormat format, Map<String, String> httpHeaders) {
        String contentType = format.getLang().getHeaderString();
        if (httpHeaders == null) {
            httpHeaders = Collections.singletonMap("Content-Type", contentType);
        } else {
            httpHeaders.put("Content-Type", contentType);
        }
        return HttpLib.httpPushWithResponse(httpClient, style, url, HttpLib.setHeaders(httpHeaders), bodyPublisher);
    }

    public static void httpDeleteGraph(String url) {
        HttpRDF.httpDeleteGraph(HttpEnv.getDftHttpClient(), url);
    }

    public static void httpDeleteGraph(HttpClient httpClient, String url) {
        URI uri = HttpLib.toRequestURI(url);
        HttpRequest requestData = HttpLib.requestBuilderFor(url).DELETE().uri(uri).build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, requestData);
        HttpLib.handleResponseNoBody(response);
    }

    static <T> Lang determineSyntax(HttpResponse<T> response, Lang dftSyntax) {
        String ctStr = HttpRDF.determineContentType(response);
        Lang lang = RDFLanguages.contentTypeToLang(ctStr);
        return HttpLib.dft(lang, dftSyntax);
    }

    static <T> String determineContentType(HttpResponse<T> response) {
        int i;
        String ctStr = HttpLib.responseHeader(response, "Content-Type");
        if (ctStr != null && (i = ctStr.indexOf(59)) >= 0) {
            ctStr = ctStr.substring(0, i);
        }
        return ctStr;
    }

    static <T> String determineBaseURI(String url, HttpResponse<T> response) {
        URI uri = response.uri();
        return uri.toString();
    }

    static HttpRequest.BodyPublisher graphToHttpBody(Graph graph, RDFFormat syntax) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(131072);
        RDFDataMgr.write((OutputStream)out, graph, syntax);
        byte[] bytes = out.toByteArray();
        IO.close(out);
        return HttpRequest.BodyPublishers.ofByteArray(bytes);
    }

    static HttpRequest.BodyPublisher datasetToHttpBody(DatasetGraph dataset, RDFFormat syntax) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(131072);
        RDFDataMgr.write((OutputStream)out, dataset, syntax);
        byte[] bytes = out.toByteArray();
        IO.close(out);
        return HttpRequest.BodyPublishers.ofByteArray(bytes);
    }
}

