/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.riot.rowset.rw.RowSetWriterXML;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetOps;
import org.apache.jena.sparql.resultset.ResultsWriter;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responses {
    private static Logger xlog = LoggerFactory.getLogger(Responses.class);
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputSPARQL = "sparql";
    private static final String contentOutputText = "text";
    private static final String contentOutputCSV = "csv";
    private static final String contentOutputTSV = "tsv";
    private static final String contentOutputThrift = "thrift";
    private static final String contentOutputJSONLD = "json-ld";
    private static final String contentOutputJSONRDF = "json-rdf";
    private static final String contentOutputTTL = "ttl";
    private static final String contentOutputTurtle = "turtle";
    private static final String contentOutputNT = "nt";
    private static final String contentOutputTriG = "trig";
    private static final String contentOutputNQuads = "n-quads";
    public static final Map<String, String> shortNamesResultSet = Map.ofEntries(Responses.entryLC("json", "application/sparql-results+json"), Responses.entryLC("sparql", "application/sparql-results+xml"), Responses.entryLC("xml", "application/sparql-results+xml"), Responses.entryLC("text", "text/plain"), Responses.entryLC("csv", "text/csv"), Responses.entryLC("tsv", "text/tab-separated-values"), Responses.entryLC("thrift", "application/sparql-results+thrift"));
    public static final Map<String, String> shortNamesGraph = Map.ofEntries(Responses.entryLC("json-ld", "application/ld+json"), Responses.entryLC("json-rdf", "application/rdf+json"), Responses.entryLC("json", "application/ld+json"), Responses.entryLC("xml", "application/rdf+xml"), Responses.entryLC("text", "text/turtle"), Responses.entryLC("ttl", "text/turtle"), Responses.entryLC("turtle", "text/turtle"), Responses.entryLC("nt", "application/n-triples"), Responses.entryLC("n-quads", "application/n-quads"), Responses.entryLC("trig", "application/trig"));

    private static Map.Entry<String, String> entryLC(String key, String value) {
        return Map.entry(Lib.lowercase(key), value);
    }

    private static void output(HttpAction action, String contentType, String charset, OutputContent proc) {
        try {
            Responses.setHttpResponse(action, contentType, charset);
            ServletOps.success(action);
            ServletOutputStream out = action.getResponseOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                action.setResponseStatus(400);
                action.log.info(String.format("[%d] Query Cancelled - results truncated (but 200 may have already been sent)", action.id));
                PrintStream ps = new PrintStream(out);
                ps.println();
                ps.println("##  Query cancelled due to timeout during execution   ##");
                ps.println("##  ****          Incomplete results           ****   ##");
                ps.flush();
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void doResponseBoolean(HttpAction action, Boolean booleanResult) {
        ResponseResults.doResponseResultSet$(action, null, booleanResult, null, DEF.rsOfferBoolean);
    }

    public static void doResponseResultSet(HttpAction action, RowSet rowSet, Prologue qPrologue) {
        ResponseResults.doResponseResultSet$(action, rowSet, null, qPrologue, DEF.rsOfferTable);
    }

    public static void doResponseGraph(HttpAction action, Graph graph) {
        DatasetGraph ds = DatasetGraphFactory.wrap(graph);
        Responses.doResponseDataset(action, ds);
    }

    public static void doResponseDataset(HttpAction action, DatasetGraph dataset) {
        ResponseGraph.doResponseDataset$(action, dataset);
    }

    public static void doResponseJson(HttpAction action, Iterator<JsonObject> jsonItem) {
        ResponseJson.doResponseJson$(action, jsonItem);
    }

    static String paramForceAccept(HttpServletRequest request) {
        String x = Responses.fetchParam(request, "force-accept");
        return x;
    }

    static String paramStylesheet(HttpServletRequest request) {
        return Responses.fetchParam(request, "stylesheet");
    }

    static String paramOutput(HttpServletRequest request, Map<String, String> map) {
        String x = Responses.fetchParam(request, "output");
        if (x == null) {
            x = Responses.fetchParam(request, "format");
        }
        if (x == null) {
            x = Responses.fetchParam(request, "results");
        }
        return Responses.expandShortName(x, map);
    }

    private static String expandShortName(String str2, Map<String, String> map) {
        if (str2 == null) {
            return null;
        }
        String key = Lib.lowercase(str2);
        String str22 = map.get(key);
        if (str22 == null) {
            return str2;
        }
        return str22;
    }

    static String paramCallback(HttpServletRequest request) {
        return Responses.fetchParam(request, "callback");
    }

    private static String fetchParam(HttpServletRequest request, String parameterName) {
        String value = request.getParameter(parameterName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static void setHttpResponse(HttpAction action, String contentType, String charset) {
        ServletOps.setNoCache(action);
        if (contentType != null) {
            if (charset != null && !Responses.isXML((String)contentType)) {
                contentType = (String)contentType + "; charset=" + charset;
            }
            action.setResponseContentType((String)contentType);
            action.log.trace("Content-Type for response: " + (String)contentType);
        }
    }

    private static boolean isXML(String contentType) {
        return contentType.equals("application/rdf+xml") || contentType.equals("application/sparql-results+xml") || contentType.equals("application/xml");
    }

    static interface OutputContent {
        public void output(OutputStream var1) throws IOException;
    }

    static class ResponseResults {
        ResponseResults() {
        }

        private static void doResponseResultSet$(HttpAction action, RowSet rowSet, Boolean booleanResult, Prologue qPrologue, AcceptList contentTypeOffer) {
            String forceAccept;
            String outputField;
            HttpServletRequest request = action.getRequest();
            long id = action.id;
            if (rowSet == null && booleanResult == null) {
                xlog.warn("doResponseResult: Both result set and boolean result are null");
                throw new FusekiException("Both result set and boolean result are null");
            }
            if (rowSet != null && booleanResult != null) {
                xlog.warn("doResponseResult: Both result set and boolean result are set");
                throw new FusekiException("Both result set and boolean result are set");
            }
            String mimeType = null;
            MediaType i = ConNeg.chooseContentType(request, contentTypeOffer, DEF.acceptResultSetXML);
            if (i != null) {
                mimeType = i.getContentTypeStr();
            }
            if ((outputField = Responses.paramOutput(request, shortNamesResultSet)) != null) {
                mimeType = outputField;
            }
            String serializationType = mimeType;
            String contentType = mimeType;
            String stylesheetURL = Responses.paramStylesheet(request);
            if (stylesheetURL != null && Objects.equals(serializationType, "application/sparql-results+xml")) {
                contentType = "application/xml";
            }
            if ((forceAccept = Responses.paramForceAccept(request)) != null) {
                contentType = "text/plain";
            }
            if (Objects.equals(serializationType, "text/plain")) {
                ResponseResults.textOutput(action, contentType, rowSet, qPrologue, booleanResult);
                return;
            }
            Lang lang = WebContent.contentTypeToLangResultSet(serializationType);
            if (lang == null) {
                ServletOps.errorBadRequest("Not recognized for SPARQL results: " + serializationType);
            }
            if (!ResultSetWriterRegistry.isRegistered(lang)) {
                ServletOps.errorBadRequest("No results writer for " + serializationType);
            }
            Context cxt = action.getContext().copy();
            String charset = "utf-8";
            String jsonCallback = null;
            switch (serializationType) {
                case "application/sparql-results+xml": {
                    charset = null;
                    if (stylesheetURL == null) break;
                    cxt.set(RowSetWriterXML.xmlStylesheet, stylesheetURL);
                    break;
                }
                case "application/sparql-results+json": {
                    jsonCallback = Responses.paramCallback(action.getRequest());
                    break;
                }
                case "application/sparql-results+thrift": {
                    if (booleanResult != null) {
                        ServletOps.errorBadRequest("Can't write a boolean result in thrift");
                    }
                    charset = null;
                    break;
                }
                case "application/sparql-results+protobuf": {
                    if (booleanResult != null) {
                        ServletOps.errorBadRequest("Can't write a boolean result in protobuf");
                    }
                    charset = null;
                }
            }
            ResponseResults.generalOutput(action, lang, contentType, charset, cxt, jsonCallback, rowSet, booleanResult);
        }

        private static void textOutput(HttpAction action, String contentType, RowSet resultSet, Prologue qPrologue, Boolean booleanResult) {
            OutputContent proc = out -> {
                if (resultSet != null) {
                    RowSetOps.out(out, resultSet, qPrologue);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.out(out, booleanResult);
                }
            };
            Responses.output(action, contentType, "utf-8", proc);
        }

        private static void generalOutput(HttpAction action, Lang rsLang, String contentType, String charset, Context context2, String callback, RowSet resultSet, Boolean booleanResult) {
            ResultsWriter rw = ResultsWriter.create().lang(rsLang).context(context2).build();
            OutputContent proc = out -> {
                if (callback != null) {
                    String callbackFunction = callback;
                    callbackFunction = callbackFunction.replace("\r", "");
                    callbackFunction = callbackFunction.replace("\n", "");
                    out.write(StrUtils.asUTF8bytes(callbackFunction));
                    out.write(40);
                    out.write(10);
                }
                if (resultSet != null) {
                    rw.write(out, resultSet);
                }
                if (booleanResult != null) {
                    rw.write(out, (boolean)booleanResult);
                }
                if (callback != null) {
                    out.write(41);
                    out.write(10);
                }
            };
            Responses.output(action, contentType, charset, proc);
        }
    }

    static class ResponseGraph {
        ResponseGraph() {
        }

        static void doResponseDataset$(HttpAction action, DatasetGraph dataset) {
            Lang lang;
            String outputField;
            HttpServletRequest request = action.getRequest();
            String mimeType = null;
            MediaType i = ConNeg.chooseContentType(request, DEF.constructOffer, DEF.acceptTurtle);
            if (i != null) {
                mimeType = i.getContentTypeStr();
            }
            if ((outputField = Responses.paramOutput(request, shortNamesGraph)) != null) {
                mimeType = outputField;
            }
            String writerMimeType = mimeType;
            if (mimeType == null) {
                Fuseki.actionLog.warn("Can't find MIME type for response");
                String x = FusekiNetLib.getAccept(request);
                Object msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
                ServletOps.error(406, (String)msg);
            }
            String contentType = mimeType;
            String charset = "utf-8";
            String forceAccept = Responses.paramForceAccept(request);
            if (forceAccept != null) {
                contentType = forceAccept;
                charset = "utf-8";
            }
            if ((lang = RDFLanguages.contentTypeToLang(contentType)) == null) {
                ServletOps.errorBadRequest("Can't determine output content type: " + contentType);
            }
            RDFFormat format = ActionLib.getNetworkFormatForLang(lang);
            try {
                ServletOps.success(action);
                ServletOutputStream out = action.getResponseOutputStream();
                try {
                    if (RDFLanguages.isQuads(lang)) {
                        ActionLib.datasetResponse(action, dataset, format, contentType);
                    } else {
                        ActionLib.graphResponse(action, dataset.getDefaultGraph(), format, contentType);
                    }
                    out.flush();
                }
                catch (JenaException ex) {
                    ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
                }
            }
            catch (ActionErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                action.log.info("Exception while writing the response model: " + ex.getMessage(), ex);
                ServletOps.errorOccurred("Exception while writing the response model: " + ex.getMessage(), ex);
            }
        }
    }

    static class ResponseJson {
        ResponseJson() {
        }

        static void doResponseJson$(HttpAction action, Iterator<JsonObject> jsonItem) {
            if (jsonItem == null) {
                xlog.warn("doResponseJson: Result set is null");
                throw new FusekiException("Result set is null");
            }
            ResponseJson.jsonOutput(action, jsonItem);
        }

        private static void jsonOutput(HttpAction action, Iterator<JsonObject> jsonItems) {
            OutputContent proc = out -> {
                if (jsonItems != null) {
                    ResultSetFormatter.output(out, jsonItems);
                }
            };
            try {
                String callback = Responses.paramCallback(action.getRequest());
                ServletOutputStream out2 = action.getResponseOutputStream();
                if (callback != null) {
                    callback = StringUtils.replaceChars(callback, "\r", "");
                    callback = StringUtils.replaceChars(callback, "\n", "");
                    out2.write(StrUtils.asUTF8bytes(callback));
                    out2.write(40);
                    out2.write(10);
                }
                ResponseJson.output(action, "application/json", "utf-8", proc);
                if (callback != null) {
                    out2.write(41);
                    out2.write(10);
                }
            }
            catch (IOException ex) {
                ServletOps.errorOccurred(ex);
            }
        }

        private static void output(HttpAction action, String contentType, String charset, OutputContent proc) {
            try {
                ResponseJson.setHttpResponse(action, contentType, charset);
                action.setResponseStatus(200);
                ServletOutputStream out = action.getResponseOutputStream();
                try {
                    proc.output(out);
                    out.flush();
                }
                catch (QueryCancelledException ex) {
                    xlog.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                    PrintStream ps = new PrintStream(out);
                    ps.println();
                    ps.println("##  Query cancelled due to timeout during execution   ##");
                    ps.println("##  ****          Incomplete results           ****   ##");
                    ps.flush();
                    out.flush();
                }
            }
            catch (IOException ex) {
                ServletOps.errorOccurred(ex);
            }
        }

        public static void setHttpResponse(HttpAction action, String contentType, String charset) {
            ServletOps.setNoCache(action);
            if (contentType != null) {
                if (charset != null) {
                    contentType = (String)contentType + "; charset=" + charset;
                }
                xlog.trace("Content-Type for response: " + (String)contentType);
                action.setResponseContentType((String)contentType);
            }
        }
    }
}

