/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CellExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;

public interface CountingBloomFilter
extends BloomFilter<CountingBloomFilter>,
CellExtractor {
    public boolean add(CellExtractor var1);

    public int getMaxCell();

    default public int getMaxInsert(BitMapExtractor bitMapExtractor) {
        if (!this.contains(bitMapExtractor)) {
            return 0;
        }
        long[] bitMaps = bitMapExtractor.asBitMapArray();
        int[] max2 = new int[]{Integer.MAX_VALUE};
        this.processCells((x, y) -> {
            if ((bitMaps[BitMaps.getLongIndex(x)] & BitMaps.getLongBit(x)) != 0L) {
                max2[0] = max2[0] <= y ? max2[0] : y;
            }
            return true;
        });
        return max2[0];
    }

    default public int getMaxInsert(BloomFilter<?> bloomFilter) {
        return this.getMaxInsert((BitMapExtractor)bloomFilter);
    }

    public int getMaxInsert(CellExtractor var1);

    default public int getMaxInsert(Hasher hasher) {
        return this.getMaxInsert(hasher.indices(this.getShape()));
    }

    default public int getMaxInsert(IndexExtractor indexExtractor) {
        return this.getMaxInsert(CellExtractor.from(indexExtractor.uniqueIndices()));
    }

    public boolean isValid();

    @Override
    default public boolean merge(BitMapExtractor bitMapExtractor) {
        return this.merge(IndexExtractor.fromBitMapExtractor(bitMapExtractor));
    }

    @Override
    default public boolean merge(BloomFilter<?> other) {
        Objects.requireNonNull(other, "other");
        return this.merge((IndexExtractor)other);
    }

    @Override
    default public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.getShape()));
    }

    @Override
    default public boolean merge(IndexExtractor indexExtractor) {
        Objects.requireNonNull(indexExtractor, "indexExtractor");
        try {
            return this.add(CellExtractor.from(indexExtractor.uniqueIndices()));
        }
        catch (IndexOutOfBoundsException e2) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()), e2);
        }
    }

    default public boolean remove(BitMapExtractor bitMapExtractor) {
        return this.remove(IndexExtractor.fromBitMapExtractor(bitMapExtractor));
    }

    default public boolean remove(BloomFilter<?> other) {
        return this.remove((IndexExtractor)other);
    }

    default public boolean remove(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.remove(hasher.indices(this.getShape()));
    }

    default public boolean remove(IndexExtractor indexExtractor) {
        Objects.requireNonNull(indexExtractor, "indexExtractor");
        try {
            return this.subtract(CellExtractor.from(indexExtractor.uniqueIndices()));
        }
        catch (IndexOutOfBoundsException e2) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()));
        }
    }

    public boolean subtract(CellExtractor var1);

    @Override
    default public IndexExtractor uniqueIndices() {
        return this;
    }
}

