/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.DynamicAccount;
import org.apache.james.fetchmail.ParsedConfiguration;
import org.apache.james.fetchmail.StoreProcessor;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchMail
implements Runnable,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchMail.class);
    private boolean fieldFetching = false;
    private ParsedConfiguration fieldConfiguration;
    private List<ParsedDynamicAccountParameters> fieldParsedDynamicAccountParameters;
    private List<Account> fieldStaticAccounts;
    private Session fieldSession;
    private Map<DynamicAccountKey, DynamicAccount> fieldDynamicAccounts;
    private UsersRepository fieldLocalUsers;
    private DNSService dnsServer;
    private MailQueue queue;
    private DomainList domainList;

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.setSessionParameters(configuration);
        ParsedConfiguration parsedConfiguration = new ParsedConfiguration(configuration, this.getLocalUsers(), this.getDNSService(), this.getDomainList(), this.getMailQueue());
        this.setParsedConfiguration(parsedConfiguration);
        List allAccounts = configuration.configurationsAt("accounts");
        if (allAccounts.size() < 1) {
            throw new ConfigurationException("Missing <accounts> section.");
        }
        if (allAccounts.size() > 1) {
            throw new ConfigurationException("Too many <accounts> sections, there must be exactly one");
        }
        HierarchicalConfiguration accounts = (HierarchicalConfiguration)allAccounts.get(0);
        if (!accounts.getKeys().hasNext()) {
            throw new ConfigurationException("Missing <account> section.");
        }
        int i = 0;
        for (HierarchicalConfiguration conf : configuration.childConfigurationsAt("accounts")) {
            String accountsChildName = conf.getRootElementName();
            if ("alllocal".equals(accountsChildName)) {
                this.getParsedDynamicAccountParameters().add(new ParsedDynamicAccountParameters(i, (Configuration)conf));
                ++i;
                continue;
            }
            if ("account".equals(accountsChildName)) {
                this.getStaticAccounts().add(new Account(i, parsedConfiguration, conf.getString("[@user]"), conf.getString("[@password]"), conf.getString("[@recipient]"), conf.getBoolean("[@ignorercpt-header]"), conf.getString("[@customrcpt-header]", ""), this.getSession()));
                ++i;
                continue;
            }
            throw new ConfigurationException("Illegal token: <" + accountsChildName + "> in <accounts>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isFetching()) {
            LOGGER.info("Triggered fetch cancelled. A fetch is already in progress.");
            return;
        }
        try {
            this.setFetching(true);
            LOGGER.info("Fetcher starting fetches");
            this.logJavaMailProperties();
            this.updateDynamicAccounts();
            ArrayList<Account> mergedAccounts = new ArrayList<Account>(this.getDynamicAccounts().size() + this.getStaticAccounts().size());
            mergedAccounts.addAll(this.getDynamicAccounts().values());
            mergedAccounts.addAll(this.getStaticAccounts());
            Collections.sort(mergedAccounts);
            LOGGER.info("Processing {} static accounts and {} dynamic accounts.", (Object)this.getStaticAccounts().size(), (Object)this.getDynamicAccounts().size());
            for (Account mergedAccount : mergedAccounts) {
                try {
                    new StoreProcessor(mergedAccount).process();
                }
                catch (MessagingException ex) {
                    LOGGER.error("A MessagingException has terminated processing of this Account", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("An Exception has terminated this fetch.", (Throwable)ex);
        }
        finally {
            LOGGER.info("Fetcher completed fetches");
            this.setFetching(false);
        }
    }

    private void logJavaMailProperties() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Session properties:");
            Properties properties = this.getSession().getProperties();
            for (Object o : properties.keySet()) {
                String key = (String)o;
                Object val = (String)properties.get(key);
                if (((String)val).length() > 40) {
                    val = ((String)val).substring(0, 37) + "...";
                }
                LOGGER.debug(key + "=" + (String)val);
            }
        }
    }

    protected boolean isFetching() {
        return this.fieldFetching;
    }

    protected void setFetching(boolean fetching) {
        this.fieldFetching = fetching;
    }

    protected ParsedConfiguration getConfiguration() {
        return this.fieldConfiguration;
    }

    protected void setParsedConfiguration(ParsedConfiguration configuration) {
        this.fieldConfiguration = configuration;
    }

    protected UsersRepository getLocalUsers() {
        return this.fieldLocalUsers;
    }

    protected DNSService getDNSService() {
        return this.dnsServer;
    }

    public void setDNSService(DNSService dns) {
        this.dnsServer = dns;
    }

    public void setUsersRepository(UsersRepository urepos) {
        this.fieldLocalUsers = urepos;
    }

    protected List<Account> getStaticAccounts() {
        if (null == this.getStaticAccountsBasic()) {
            this.updateStaticAccounts();
            return this.getStaticAccounts();
        }
        return this.fieldStaticAccounts;
    }

    private List<Account> getStaticAccountsBasic() {
        return this.fieldStaticAccounts;
    }

    protected void setStaticAccounts(List<Account> accounts) {
        this.fieldStaticAccounts = accounts;
    }

    protected void updateStaticAccounts() {
        this.setStaticAccounts(this.computeStaticAccounts());
    }

    protected void updateParsedDynamicAccountParameters() {
        this.setParsedDynamicAccountParameters(this.computeParsedDynamicAccountParameters());
    }

    protected void updateDynamicAccounts() throws ConfigurationException {
        this.setDynamicAccounts(this.computeDynamicAccounts());
    }

    protected List<Account> computeStaticAccounts() {
        return new ArrayList<Account>();
    }

    protected List<ParsedDynamicAccountParameters> computeParsedDynamicAccountParameters() {
        return new ArrayList<ParsedDynamicAccountParameters>();
    }

    protected Map<DynamicAccountKey, DynamicAccount> computeDynamicAccounts() throws ConfigurationException {
        HashMap<DynamicAccountKey, DynamicAccount> newAccounts;
        try {
            newAccounts = new HashMap<DynamicAccountKey, DynamicAccount>(this.getLocalUsers().countUsers() * this.getParsedDynamicAccountParameters().size());
        }
        catch (UsersRepositoryException e) {
            throw new ConfigurationException("Unable to access UsersRepository", (Throwable)e);
        }
        Map<DynamicAccountKey, DynamicAccount> oldAccounts = this.getDynamicAccountsBasic();
        if (null == oldAccounts) {
            oldAccounts = new HashMap<DynamicAccountKey, DynamicAccount>(0);
        }
        for (ParsedDynamicAccountParameters parsedDynamicAccountParameters : this.getParsedDynamicAccountParameters()) {
            Map<DynamicAccountKey, DynamicAccount> accounts = this.computeDynamicAccounts(oldAccounts, parsedDynamicAccountParameters);
            Iterator<DynamicAccountKey> oldAccountsIterator = oldAccounts.keySet().iterator();
            while (oldAccountsIterator.hasNext()) {
                if (!accounts.containsKey(oldAccountsIterator.next())) continue;
                oldAccountsIterator.remove();
            }
            newAccounts.putAll(accounts);
        }
        return newAccounts;
    }

    protected Map<DynamicAccountKey, DynamicAccount> getDynamicAccounts() throws ConfigurationException {
        if (null == this.getDynamicAccountsBasic()) {
            this.updateDynamicAccounts();
            return this.getDynamicAccounts();
        }
        return this.fieldDynamicAccounts;
    }

    private Map<DynamicAccountKey, DynamicAccount> getDynamicAccountsBasic() {
        return this.fieldDynamicAccounts;
    }

    protected void setDynamicAccounts(Map<DynamicAccountKey, DynamicAccount> dynamicAccounts) {
        this.fieldDynamicAccounts = dynamicAccounts;
    }

    protected Map<DynamicAccountKey, DynamicAccount> computeDynamicAccounts(Map<DynamicAccountKey, DynamicAccount> oldAccounts, ParsedDynamicAccountParameters parameters) throws ConfigurationException {
        Iterator usersIterator;
        HashMap<DynamicAccountKey, DynamicAccount> accounts;
        try {
            accounts = new HashMap<DynamicAccountKey, DynamicAccount>(this.getLocalUsers().countUsers());
            usersIterator = this.getLocalUsers().list();
        }
        catch (UsersRepositoryException e) {
            throw new ConfigurationException("Unable to access UsersRepository", (Throwable)e);
        }
        while (usersIterator.hasNext()) {
            String userName = ((Username)usersIterator.next()).asString();
            DynamicAccountKey key = new DynamicAccountKey(userName, parameters.getSequenceNumber());
            DynamicAccount account = oldAccounts.get(key);
            if (null == account) {
                account = new DynamicAccount(parameters.getSequenceNumber(), this.getConfiguration(), userName, parameters.getUserPrefix(), parameters.getUserSuffix(), parameters.getPassword(), parameters.getRecipientPrefix(), parameters.getRecipientSuffix(), parameters.isIgnoreRecipientHeader(), parameters.getCustomRecipientHeader(), this.getSession());
            }
            accounts.put(key, account);
        }
        return accounts;
    }

    protected void resetDynamicAccounts() {
        this.setDynamicAccounts(null);
    }

    protected List<ParsedDynamicAccountParameters> getParsedDynamicAccountParameters() {
        if (null == this.getParsedDynamicAccountParametersBasic()) {
            this.updateParsedDynamicAccountParameters();
            return this.getParsedDynamicAccountParameters();
        }
        return this.fieldParsedDynamicAccountParameters;
    }

    private List<ParsedDynamicAccountParameters> getParsedDynamicAccountParametersBasic() {
        return this.fieldParsedDynamicAccountParameters;
    }

    protected void setParsedDynamicAccountParameters(List<ParsedDynamicAccountParameters> parsedDynamicAccountParameters) {
        this.fieldParsedDynamicAccountParameters = parsedDynamicAccountParameters;
    }

    protected Session getSession() {
        Session session = this.getSessionBasic();
        if (null == session) {
            this.updateSession();
            return this.getSession();
        }
        return session;
    }

    private Session getSessionBasic() {
        return this.fieldSession;
    }

    protected Session computeSession() {
        return Session.getInstance((Properties)new Properties(System.getProperties()));
    }

    protected void updateSession() {
        this.setSession(this.computeSession());
    }

    protected void setSession(Session session) {
        this.fieldSession = session;
    }

    protected void setSessionParameters(HierarchicalConfiguration<ImmutableNode> configuration) {
        if (configuration.getKeys("javaMailProperties.property").hasNext()) {
            Properties properties = this.getSession().getProperties();
            List allProperties = configuration.configurationsAt("javaMailProperties.property");
            for (HierarchicalConfiguration propConf : allProperties) {
                String nameProp = propConf.getString("[@name]");
                String valueProp = propConf.getString("[@value]");
                properties.setProperty(nameProp, valueProp);
                LOGGER.debug("Set property name: {} to: {}", (Object)nameProp, (Object)valueProp);
            }
        }
    }

    public void setMailQueue(MailQueue queue) {
        this.queue = queue;
    }

    public MailQueue getMailQueue() {
        return this.queue;
    }

    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public DomainList getDomainList() {
        return this.domainList;
    }

    private static final class ParsedDynamicAccountParameters {
        private String fieldUserPrefix;
        private String fieldUserSuffix;
        private String fieldPassword;
        private int fieldSequenceNumber;
        private boolean fieldIgnoreRecipientHeader;
        private String fieldRecipientPrefix;
        private String fieldRecipientSuffix;
        private String customRecipientHeader;

        private ParsedDynamicAccountParameters() {
        }

        public ParsedDynamicAccountParameters(int sequenceNumber, Configuration configuration) {
            this();
            this.setSequenceNumber(sequenceNumber);
            this.setUserPrefix(configuration.getString("[@userprefix]", ""));
            this.setUserSuffix(configuration.getString("[@usersuffix]", ""));
            this.setRecipientPrefix(configuration.getString("[@recipientprefix]", ""));
            this.setRecipientSuffix(configuration.getString("[@recipientsuffix]", ""));
            this.setPassword(configuration.getString("[@password]"));
            this.setIgnoreRecipientHeader(configuration.getBoolean("[@ignorercpt-header]"));
            this.setCustomRecipientHeader(configuration.getString("[@customrcpt-header]", ""));
        }

        public String getCustomRecipientHeader() {
            return this.customRecipientHeader;
        }

        public String getRecipientPrefix() {
            return this.fieldRecipientPrefix;
        }

        public String getRecipientSuffix() {
            return this.fieldRecipientSuffix;
        }

        public String getUserPrefix() {
            return this.fieldUserPrefix;
        }

        public String getUserSuffix() {
            return this.fieldUserSuffix;
        }

        public void setCustomRecipientHeader(String customRecipientHeader) {
            this.customRecipientHeader = customRecipientHeader;
        }

        protected void setRecipientPrefix(String recipientprefix) {
            this.fieldRecipientPrefix = recipientprefix;
        }

        protected void setRecipientSuffix(String recipientsuffix) {
            this.fieldRecipientSuffix = recipientsuffix;
        }

        protected void setUserPrefix(String userprefix) {
            this.fieldUserPrefix = userprefix;
        }

        protected void setUserSuffix(String userSuffix) {
            this.fieldUserSuffix = userSuffix;
        }

        public String getPassword() {
            return this.fieldPassword;
        }

        protected void setIgnoreRecipientHeader(boolean ignoreRecipientHeader) {
            this.fieldIgnoreRecipientHeader = ignoreRecipientHeader;
        }

        protected void setPassword(String password) {
            this.fieldPassword = password;
        }

        public boolean isIgnoreRecipientHeader() {
            return this.fieldIgnoreRecipientHeader;
        }

        public int getSequenceNumber() {
            return this.fieldSequenceNumber;
        }

        protected void setSequenceNumber(int sequenceNumber) {
            this.fieldSequenceNumber = sequenceNumber;
        }
    }

    private static final class DynamicAccountKey {
        private String fieldUserName;
        private int fieldSequenceNumber;

        private DynamicAccountKey() {
        }

        public DynamicAccountKey(String userName, int sequenceNumber) {
            this();
            this.setUserName(userName);
            this.setSequenceNumber(sequenceNumber);
        }

        public boolean equals(Object obj) {
            return null != obj && obj.getClass() == this.getClass() && this.getUserName().equals(((DynamicAccountKey)obj).getUserName()) && this.getSequenceNumber() == ((DynamicAccountKey)obj).getSequenceNumber();
        }

        public int hashCode() {
            return this.getUserName().hashCode() ^ this.getSequenceNumber();
        }

        public int getSequenceNumber() {
            return this.fieldSequenceNumber;
        }

        public String getUserName() {
            return this.fieldUserName;
        }

        protected void setSequenceNumber(int sequenceNumber) {
            this.fieldSequenceNumber = sequenceNumber;
        }

        protected void setUserName(String userName) {
            this.fieldUserName = userName;
        }
    }
}

