/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class Document {
    private final DocumentId id;
    private final String name;
    private final String description;
    private final long creationDate;
    private final long modificationDate;
    private final long expirationDate;
    private final boolean ciphered;
    private final String type;
    private final long size;
    private final String metaData;
    private final String sha256sum;
    private final boolean hasThumbnail;
    private final int shared;

    public Document(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="creationDate") long creationDate, @JsonProperty(value="modificationDate") long modificationDate, @JsonProperty(value="expirationDate") long expirationDate, @JsonProperty(value="ciphered") boolean ciphered, @JsonProperty(value="type") String type, @JsonProperty(value="size") long size, @JsonProperty(value="metaData") String metaData, @JsonProperty(value="sha256sum") String sha256sum, @JsonProperty(value="hasThumbnail") boolean hasThumbnail, @JsonProperty(value="shared") int shared) {
        this.id = new DocumentId(UUID.fromString(uuid));
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.expirationDate = expirationDate;
        this.ciphered = ciphered;
        this.type = type;
        this.size = size;
        this.metaData = metaData;
        this.sha256sum = sha256sum;
        this.hasThumbnail = hasThumbnail;
        this.shared = shared;
    }

    public DocumentId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getModificationDate() {
        return this.modificationDate;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isCiphered() {
        return this.ciphered;
    }

    public String getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getSha256sum() {
        return this.sha256sum;
    }

    public boolean isHasThumbnail() {
        return this.hasThumbnail;
    }

    public int getShared() {
        return this.shared;
    }

    public final boolean equals(Object o) {
        if (o instanceof Document) {
            Document document = (Document)o;
            return Objects.equals(this.creationDate, document.creationDate) && Objects.equals(this.modificationDate, document.modificationDate) && Objects.equals(this.expirationDate, document.expirationDate) && Objects.equals(this.ciphered, document.ciphered) && Objects.equals(this.size, document.size) && Objects.equals(this.hasThumbnail, document.hasThumbnail) && Objects.equals(this.shared, document.shared) && Objects.equals(this.id, document.id) && Objects.equals(this.name, document.name) && Objects.equals(this.description, document.description) && Objects.equals(this.type, document.type) && Objects.equals(this.metaData, document.metaData) && Objects.equals(this.sha256sum, document.sha256sum);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.creationDate, this.modificationDate, this.expirationDate, this.ciphered, this.type, this.size, this.metaData, this.sha256sum, this.hasThumbnail, this.shared);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("creationDate", this.creationDate).add("modificationDate", this.modificationDate).add("expirationDate", this.expirationDate).add("ciphered", this.ciphered).add("type", (Object)this.type).add("size", this.size).add("metaData", (Object)this.metaData).add("sha256sum", (Object)this.sha256sum).add("hasThumbnail", this.hasThumbnail).add("shared", this.shared).toString();
    }

    public static class DocumentId {
        private final UUID id;

        DocumentId(UUID id) {
            Preconditions.checkNotNull((Object)id);
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String asString() {
            return this.id.toString();
        }

        public final boolean equals(Object o) {
            if (o instanceof DocumentId) {
                DocumentId that = (DocumentId)o;
                return Objects.equals(this.id, that.id);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
        }
    }
}

