/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedConnectAccessLogMessage
extends TextFormattedAccessLogMessage
implements ConnectAccessLogMessage {
    private static final long serialVersionUID = 5169063087516755242L;
    @Nullable
    private final Integer sourcePort;
    @Nullable
    private final Integer targetPort;
    @Nullable
    private final String clientConnectionPolicyName;
    @Nullable
    private final String protocolName;
    @Nullable
    private final String sourceAddress = this.getString(TextFormattedAccessLogFields.CONNECT_FROM_ADDRESS);
    @Nullable
    private final String targetAddress;

    public TextFormattedConnectAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedConnectAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.sourcePort = this.getIntegerNoThrow(TextFormattedAccessLogFields.CONNECT_FROM_PORT);
        this.targetAddress = this.getString(TextFormattedAccessLogFields.CONNECT_TO_ADDRESS);
        this.targetPort = this.getIntegerNoThrow(TextFormattedAccessLogFields.CONNECT_TO_PORT);
        this.protocolName = this.getString(TextFormattedAccessLogFields.PROTOCOL);
        this.clientConnectionPolicyName = this.getString(TextFormattedAccessLogFields.CLIENT_CONNECTION_POLICY);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CONNECT;
    }

    @Override
    @Nullable
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    @Nullable
    public Integer getSourcePort() {
        return this.sourcePort;
    }

    @Override
    @Nullable
    public String getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    @Nullable
    public Integer getTargetPort() {
        return this.targetPort;
    }

    @Override
    @Nullable
    public String getProtocolName() {
        return this.protocolName;
    }

    @Override
    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicyName;
    }
}

