/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.ReactiveSubscriber;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.jmap.api.filtering.impl.DefineRulesCommand;
import org.apache.james.jmap.api.filtering.impl.DefineRulesCommandHandler;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregate;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventSourcingFilteringManagement
implements FilteringManagement {
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final ReadProjection readProjection;
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public EventSourcingFilteringManagement(EventStore eventStore) {
        this(eventStore, new NoReadProjection(eventStore));
    }

    public EventSourcingFilteringManagement(EventStore eventStore, ReadProjection readProjection) {
        this.readProjection = new NoReadProjection(eventStore);
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new DefineRulesCommandHandler(eventStore)), (Set)((Set)readProjection.subscriber(aggregateId -> new NoReadProjection(eventStore).listRulesForUser((Username)aggregateId)).map(Subscriber.class::cast).map(ImmutableSet::of).orElse(NO_SUBSCRIBER)), (EventStore)eventStore);
    }

    @Override
    public Publisher<Version> defineRulesForUser(Username username, List<Rule> rules, Optional<Version> ifInState) {
        return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new DefineRulesCommand(username, rules, ifInState))).map(events -> Version.from(events.stream().map(Event::eventId).sorted(Comparator.reverseOrder()).findFirst()));
    }

    @Override
    public Publisher<Rules> listRulesForUser(Username username) {
        return this.readProjection.listRulesForUser(username);
    }

    @Override
    public Publisher<Version> getLatestVersion(Username username) {
        return this.readProjection.getLatestVersion(username);
    }

    public static class NoReadProjection
    implements ReadProjection {
        private final EventStore eventStore;

        @Inject
        public NoReadProjection(EventStore eventStore) {
            this.eventStore = eventStore;
        }

        @Override
        public Publisher<Rules> listRulesForUser(Username username) {
            Preconditions.checkNotNull((Object)username);
            FilteringAggregateId aggregateId = new FilteringAggregateId(username);
            return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(history -> FilteringAggregate.load(aggregateId, history).listRules()).defaultIfEmpty((Object)new Rules((List<Rule>)ImmutableList.of(), Version.INITIAL));
        }

        @Override
        public Publisher<Version> getLatestVersion(Username username) {
            Preconditions.checkNotNull((Object)username);
            FilteringAggregateId aggregateId = new FilteringAggregateId(username);
            return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(History::getVersionAsJava).map(eventIdOptional -> eventIdOptional.map(eventId -> new Version(eventId.value())).orElse(Version.INITIAL));
        }

        @Override
        public Optional<ReactiveSubscriber> subscriber(Function<Username, Publisher<Rules>> ruleLoader) {
            return Optional.empty();
        }
    }

    public static interface ReadProjection {
        public Publisher<Rules> listRulesForUser(Username var1);

        public Publisher<Version> getLatestVersion(Username var1);

        public Optional<ReactiveSubscriber> subscriber(Function<Username, Publisher<Rules>> var1);
    }
}

