/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentV2Table;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentDAOV2 {
    private final BlobId.Factory blobIdFactory;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement insertMessageIdStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listBlobs;
    private final ConsistencyLevel consistencyLevel;

    public static DAOAttachment from(AttachmentMetadata attachment, BlobId blobId) {
        return new DAOAttachment(attachment.getMessageId(), attachment.getAttachmentId(), blobId, attachment.getType(), attachment.getSize());
    }

    private static Mono<DAOAttachment> fromRow(Row row, BlobId.Factory blobIfFactory, Mono<CassandraMessageId> fallback) {
        return Optional.ofNullable(row.getUUID("message_id")).map(CassandraMessageId.Factory::of).map(Mono::just).orElse(fallback).map(messageIdAsUUid -> new DAOAttachment((MessageId)messageIdAsUUid, AttachmentId.from((String)row.getString("id")), blobIfFactory.from(row.getString("blobId")), ContentType.of((String)row.getString("type")), row.getLong("size")));
    }

    @Inject
    public CassandraAttachmentDAOV2(BlobId.Factory blobIdFactory, Session session, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.blobIdFactory = blobIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getRegular();
        this.selectStatement = this.prepareSelect(session);
        this.insertStatement = this.prepareInsert(session);
        this.deleteStatement = this.prepareDelete(session);
        this.listBlobs = this.prepareSelectBlobs(session);
        this.insertMessageIdStatement = this.prepareInsertMessageId(session);
    }

    private PreparedStatement prepareSelectBlobs(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"blobId"}).from("attachmentV2"));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("attachmentV2").where(QueryBuilder.eq((String)"idAsUUID", (Object)QueryBuilder.bindMarker((String)"idAsUUID"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"attachmentV2").value("idAsUUID", (Object)QueryBuilder.bindMarker((String)"idAsUUID")).value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("blobId", (Object)QueryBuilder.bindMarker((String)"blobId")).value("type", (Object)QueryBuilder.bindMarker((String)"type")).value("message_id", (Object)QueryBuilder.bindMarker((String)"message_id")).value("size", (Object)QueryBuilder.bindMarker((String)"size")));
    }

    private PreparedStatement prepareInsertMessageId(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"attachmentV2").value("idAsUUID", (Object)QueryBuilder.bindMarker((String)"idAsUUID")).value("message_id", (Object)QueryBuilder.bindMarker((String)"message_id")));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraAttachmentV2Table.FIELDS).from("attachmentV2").where(QueryBuilder.eq((String)"idAsUUID", (Object)QueryBuilder.bindMarker((String)"idAsUUID"))));
    }

    public Mono<DAOAttachment> getAttachment(AttachmentId attachmentId, Mono<CassandraMessageId> fallback) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.cassandraAsyncExecutor.executeSingleRow(this.selectStatement.bind().setUUID("idAsUUID", attachmentId.asUUID()).setConsistencyLevel(this.consistencyLevel)).flatMap(row -> CassandraAttachmentDAOV2.fromRow(row, this.blobIdFactory, fallback));
    }

    public Mono<Void> storeAttachment(DAOAttachment attachment) {
        CassandraMessageId messageId = (CassandraMessageId)attachment.getMessageId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertStatement.bind().setUUID("idAsUUID", attachment.getAttachmentId().asUUID()).setString("id", attachment.getAttachmentId().getId()).setLong("size", attachment.getSize()).setUUID("message_id", messageId.get()).setString("type", attachment.getType().asString()).setString("blobId", attachment.getBlobId().asString()));
    }

    public Mono<Void> insertMessageId(AttachmentId attachmentId, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertMessageIdStatement.bind().setUUID("idAsUUID", attachmentId.asUUID()).setUUID("message_id", cassandraMessageId.get()));
    }

    public Mono<Void> delete(AttachmentId attachmentId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("idAsUUID", attachmentId.asUUID()));
    }

    public Flux<BlobId> listBlobs() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBlobs.bind()).map(row -> this.blobIdFactory.from(row.getString("blobId")));
    }

    public static class DAOAttachment {
        private final MessageId messageId;
        private final AttachmentId attachmentId;
        private final BlobId blobId;
        private final ContentType type;
        private final long size;

        DAOAttachment(MessageId messageId, AttachmentId attachmentId, BlobId blobId, ContentType type, long size) {
            this.messageId = messageId;
            this.attachmentId = attachmentId;
            this.blobId = blobId;
            this.type = type;
            this.size = size;
        }

        public AttachmentId getAttachmentId() {
            return this.attachmentId;
        }

        public BlobId getBlobId() {
            return this.blobId;
        }

        public ContentType getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public AttachmentMetadata toAttachment() {
            return AttachmentMetadata.builder().attachmentId(this.attachmentId).type(this.type).size(this.size).messageId(this.messageId).build();
        }

        public final boolean equals(Object o) {
            if (o instanceof DAOAttachment) {
                DAOAttachment that = (DAOAttachment)o;
                return Objects.equals(this.size, that.size) && Objects.equals(this.attachmentId, that.attachmentId) && Objects.equals(this.blobId, that.blobId) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.type, that.type);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.attachmentId, this.blobId, this.type, this.size, this.messageId);
        }
    }
}

