/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.Set;
import org.apache.james.backends.es.v7.ClientProvider;
import org.apache.james.backends.es.v7.ElasticSearchHealthCheck;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.mailbox.elasticsearch.v7.ElasticSearchMailboxConfiguration;
import org.apache.james.quota.search.elasticsearch.v7.ElasticSearchQuotaConfiguration;

public class ElasticSearchClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ClientProvider.class).in(Scopes.SINGLETON);
        this.bind(ReactorElasticSearchClient.class).toProvider(ClientProvider.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(ElasticSearchHealthCheck.class);
    }

    @Provides
    @Singleton
    Set<IndexName> provideIndexNames(ElasticSearchMailboxConfiguration mailboxConfiguration, ElasticSearchQuotaConfiguration quotaConfiguration) {
        return ImmutableSet.of((Object)mailboxConfiguration.getIndexMailboxName(), (Object)quotaConfiguration.getIndexQuotaRatioName());
    }
}

