/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.mime4j.ExampleMail;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTokenEmbeddedMessageTest {
    MimeTokenStream stream;

    @Before
    public void setUp() throws Exception {
        this.stream = new MimeTokenStream();
        ByteArrayInputStream in = new ByteArrayInputStream(ExampleMail.MIME_MULTIPART_EMBEDDED_MESSAGES_BYTES);
        this.stream.parse((InputStream)in);
    }

    @Test
    public void testWhenRecurseShouldVisitInnerMailsAndInnerMultiparts() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_RECURSE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("Rhubarb!\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("987654321AHPLA\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MESSAGE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("Custard!\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("CUSTARDCUSTARDCUSTARD\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_END_MULTIPART);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.checkInputStream("--4.66920160910299\r\nContent-Type: image/gif\r\nContent-Transfer-Encoding: base64\r\nMIME-Version: 1.0\r\nContent-ID: 238478934723847238947892374\r\nContent-Description: Bogus Image Data\r\n\r\nABCDFEGHIJKLMNO\r\n\r\n--4.66920160910299\r\nContent-Type: message/rfc822\r\n\r\nFrom: Timothy Tayler <timothy@example.org>\r\nTo: John Smith <john@example.org>\r\nDate: Sat, 16 Feb 2008 12:00:00 +0000 (GMT)\r\nSubject: Another Example Email\r\nContent-Type: multipart/mixed;boundary=2.50290787509\r\n\r\nYet another preamble\r\n\r\n--2.50290787509\r\nContent-Type: text/plain\r\n\r\nRhubard AND Custard!\r\n\r\n--2.50290787509\r\nContent-Type: multipart/alternative;boundary=3.243F6A8885A308D3\r\n\r\n--3.243F6A8885A308D3\r\nContent-Type: text/plain\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3\r\n\r\nContent-Type: text/richtext\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3--\r\n\r\n--2.50290787509--\r\n\r\n--4.66920160910299--");
        this.nextIs(EntityState.T_END_MULTIPART);
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_EPILOGUE);
        this.nextIs(EntityState.T_END_MULTIPART);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_OF_STREAM);
    }

    @Test
    public void testWhenFlatAtStartShouldIgnoreMultipartStructure() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_FLAT);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("Start with a preamble\r\n\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nRhubarb!\r\n\r\n--1729\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n\r\n987654321AHPLA\r\n\r\n--1729\r\nContent-Type: message/rfc822\r\n\r\nFrom: Timothy Tayler <timothy@example.org>\r\nTo: Samual Smith <samual@example.org>\r\nDate: Thu, 14 Feb 2008 12:00:00 +0000 (GMT)\r\nSubject: A Multipart Alternative Email\r\nContent-Type: multipart/alternative;boundary=42\r\n\r\nThis message has a premable\r\n\r\n--42\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nCustard!\r\n\r\n--42\r\nContent-Type: application/octet-stream\r\n\r\nCUSTARDCUSTARDCUSTARD\r\n\r\n--42--\r\n\r\n--1729\r\nContent-Type: multipart/mixed; boundary=4.66920160910299\r\n\r\n--4.66920160910299\r\nContent-Type: image/gif\r\nContent-Transfer-Encoding: base64\r\nMIME-Version: 1.0\r\nContent-ID: 238478934723847238947892374\r\nContent-Description: Bogus Image Data\r\n\r\nABCDFEGHIJKLMNO\r\n\r\n--4.66920160910299\r\nContent-Type: message/rfc822\r\n\r\nFrom: Timothy Tayler <timothy@example.org>\r\nTo: John Smith <john@example.org>\r\nDate: Sat, 16 Feb 2008 12:00:00 +0000 (GMT)\r\nSubject: Another Example Email\r\nContent-Type: multipart/mixed;boundary=2.50290787509\r\n\r\nYet another preamble\r\n\r\n--2.50290787509\r\nContent-Type: text/plain\r\n\r\nRhubard AND Custard!\r\n\r\n--2.50290787509\r\nContent-Type: multipart/alternative;boundary=3.243F6A8885A308D3\r\n\r\n--3.243F6A8885A308D3\r\nContent-Type: text/plain\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3\r\n\r\nContent-Type: text/richtext\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3--\r\n\r\n--2.50290787509--\r\n\r\n--4.66920160910299--\r\n--1729--\r\n\r\n");
        this.nextIs(EntityState.T_END_MESSAGE);
    }

    @Test
    public void testWhenFlatShouldIgnoreInnerMailsAndInnerMultiparts() throws Exception {
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.stream.setRecursionMode(RecursionMode.M_FLAT);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("Rhubarb!\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("987654321AHPLA\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("From: Timothy Tayler <timothy@example.org>\r\nTo: Samual Smith <samual@example.org>\r\nDate: Thu, 14 Feb 2008 12:00:00 +0000 (GMT)\r\nSubject: A Multipart Alternative Email\r\nContent-Type: multipart/alternative;boundary=42\r\n\r\nThis message has a premable\r\n\r\n--42\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nCustard!\r\n\r\n--42\r\nContent-Type: application/octet-stream\r\n\r\nCUSTARDCUSTARDCUSTARD\r\n\r\n--42--\r\n");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.checkInputStream("--4.66920160910299\r\nContent-Type: image/gif\r\nContent-Transfer-Encoding: base64\r\nMIME-Version: 1.0\r\nContent-ID: 238478934723847238947892374\r\nContent-Description: Bogus Image Data\r\n\r\nABCDFEGHIJKLMNO\r\n\r\n--4.66920160910299\r\nContent-Type: message/rfc822\r\n\r\nFrom: Timothy Tayler <timothy@example.org>\r\nTo: John Smith <john@example.org>\r\nDate: Sat, 16 Feb 2008 12:00:00 +0000 (GMT)\r\nSubject: Another Example Email\r\nContent-Type: multipart/mixed;boundary=2.50290787509\r\n\r\nYet another preamble\r\n\r\n--2.50290787509\r\nContent-Type: text/plain\r\n\r\nRhubard AND Custard!\r\n\r\n--2.50290787509\r\nContent-Type: multipart/alternative;boundary=3.243F6A8885A308D3\r\n\r\n--3.243F6A8885A308D3\r\nContent-Type: text/plain\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3\r\n\r\nContent-Type: text/richtext\r\n\r\nRhubard?Custard?\r\n\r\n--3.243F6A8885A308D3--\r\n\r\n--2.50290787509--\r\n\r\n--4.66920160910299--");
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextIs(EntityState.T_EPILOGUE);
        this.nextIs(EntityState.T_END_MULTIPART);
    }

    private void checkInputStream(String expected) throws Exception {
        InputStream inputStream = this.stream.getInputStream();
        int next = inputStream.read();
        int i = 0;
        while (next != -1) {
            Assert.assertEquals((String)("@" + i), (long)expected.charAt(i++), (long)((char)next));
            next = inputStream.read();
        }
        Assert.assertEquals((long)expected.length(), (long)i);
    }

    private void nextIs(EntityState state) throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)state), (Object)MimeTokenStream.stateToString((EntityState)this.stream.next()));
    }
}

