/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;

public class Offset
extends Node {
    private final Expression rowCount;

    public Offset(Expression rowCount) {
        super(null);
        Preconditions.checkArgument((rowCount instanceof LongLiteral || rowCount instanceof Parameter ? 1 : 0) != 0, (String)"unexpected rowCount class: %s", (Object)rowCount.getClass().getSimpleName());
        this.rowCount = rowCount;
    }

    public Offset(NodeLocation location, Expression rowCount) {
        super(Objects.requireNonNull(location, "location is null"));
        Preconditions.checkArgument((rowCount instanceof LongLiteral || rowCount instanceof Parameter ? 1 : 0) != 0, (String)"unexpected rowCount class: %s", (Object)rowCount.getClass().getSimpleName());
        this.rowCount = rowCount;
    }

    public Expression getRowCount() {
        return this.rowCount;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.rowCount);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Offset o = (Offset)obj;
        return Objects.equals(this.rowCount, o.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", (Object)this.rowCount).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Offset.sameClass(this, other);
    }
}

