/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.ConcatDeviceAndBindSchemaForExpressionVisitor;
import org.apache.tsfile.enums.TSDataType;

public class ConcatDeviceAndBindSchemaForHavingVisitor
extends ConcatDeviceAndBindSchemaForExpressionVisitor {
    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, ConcatDeviceAndBindSchemaForExpressionVisitor.Context context) {
        PartialPath measurement = timeSeriesOperand.getPath();
        PartialPath concatPath = context.getDevicePath().concatPath(measurement);
        List actualPaths = (List)context.getSchemaTree().searchMeasurementPaths((PartialPath)concatPath).left;
        if (actualPaths.isEmpty()) {
            return Collections.singletonList(new TimeSeriesOperand((PartialPath)new MeasurementPath(concatPath, TSDataType.UNKNOWN)));
        }
        ArrayList<MeasurementPath> nonViewActualPaths = new ArrayList<MeasurementPath>();
        ArrayList<MeasurementPath> viewPaths = new ArrayList<MeasurementPath>();
        for (MeasurementPath measurementPath : actualPaths) {
            if (measurementPath.getMeasurementSchema().isLogicalView()) {
                viewPaths.add(measurementPath);
                continue;
            }
            nonViewActualPaths.add(measurementPath);
        }
        List<Expression> reconstructTimeSeriesOperands = ExpressionUtils.reconstructTimeSeriesOperandsWithMemoryCheck(timeSeriesOperand, nonViewActualPaths, context.getQueryContext());
        for (MeasurementPath measurementPath : viewPaths) {
            Expression replacedExpression = BindSchemaForExpressionVisitor.transformViewPath(measurementPath, context.getSchemaTree());
            if (!(replacedExpression instanceof TimeSeriesOperand)) {
                throw new SemanticException("Only writable view timeseries are supported in ALIGN BY DEVICE queries.");
            }
            replacedExpression.setViewPath((PartialPath)measurementPath);
            reconstructTimeSeriesOperands.add(replacedExpression);
        }
        return reconstructTimeSeriesOperands;
    }
}

